<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\AssignmentDetails;
use App\Models\Admin\Assignments;
use App\Models\Admin\AssignmentWhyChoose;
use App\Models\Admin\Coupons;
use App\Models\Admin\EducationalSessions;
use App\Models\Admin\Medium;
use App\Models\Admin\Types;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class AssignmentsController extends Controller
{
    // function checkAssignmentLink($assignment_url, $encrypted_id = "")
    // {
    //     $assignment_url = str_replace(['/', ' '], '-', $assignment_url);
    //     $assignment_url = preg_replace('/[^a-z0-9-]+/', '-', $assignment_url);
    //     $assignment_url = trim($assignment_url, '-');
    //     $assignment_url = preg_replace('/-+/', '-', $assignment_url);
    //     $original_link = $assignment_url;

    //     $id = (isset($encrypted_id) && !empty($encrypted_id)) ? Crypt::decrypt($encrypted_id) : 0;
    //     $suffix = 1;
    //     do {
    //         $count = $id != 0 ? Courses::where('course_url', $assignment_url)->where('id', '!=', $id)->count() : Courses::where('course_url', $assignment_url)->count();

    //         if ($count > 0) {
    //             $assignment_url = $original_link . '-' . $suffix;
    //             $suffix++;
    //         } else {
    //             break;
    //         }
    //     } while (true);

    //     return $assignment_url;
    // }

    function manageAssignments(Request $request)
    {
        $assignments = Assignments::select('id', 'position_order', 'assignment_code', 'assignment_title', 'assignment_image', 'status')->orderBy('position_order')->get();
        foreach ($assignments as $assignment) {
            $assignment->encrypted_id = Crypt::encrypt($assignment->id);
        }

        $main_page = 'assignments_management';
        $currentPage = "manage_courses";
        $model = Crypt::encrypt('Assignments');
        return view('admin.manage_assignments', ['courseId' => $request->course, 'assignmentsData' => $assignments, 'model' => $model, 'main_page' => $main_page, 'currentPage' => $currentPage]);
    }

    // function addAssignment(Request $request)
    // {
    //     if ($request->isMethod('post')) {
    //         $request->validate([
    //             'type_ids' => 'array|nullable',
    //             'language_ids' => 'array|nullable',
    //             'session_ids' => 'array|nullable',
    //             'coupon_ids' => 'array|nullable',
    //             'assignment_code' => 'required|string',
    //             'assignment_title' => 'required|string',
    //             'maximum_retail_price' => 'required|numeric',
    //             'selling_price' => 'required|numeric',
    //             // 'included_section_icons' => 'array|nullable',
    //             // 'included_section_titles' => 'array|nullable',
    //             // 'included_section_descriptions' => 'array|nullable',
    //         ], [
    //             'assignment_code.required' => 'Please provide a Assignment Code.',
    //             'assignment_code.string' => 'Assignment Code must be a string.',
    //             'assignment_title.required' => 'Please provide Assignment Title.',
    //             'assignment_title.string' => 'Assignment Title must be a string.',
    //             'maximum_retail_price.required' => 'Please provide MRP.',
    //             'maximum_retail_price.numeric' => 'MRP must be in numeric.',
    //             'selling_price.required' => 'Please provide Selling Price.',
    //             'selling_price.numeric' => 'Selling Price must be in numeric.',
    //         ]);

    //         $order = Assignments::max('position_order');
    //         $position_order = ($order !== null) ? $order + 1 : 1;

    //         $type_ids = array_map(function ($id) {
    //             return Crypt::decrypt($id);
    //         }, $request->type_ids ?? []);
    //         $language_ids = array_map(function ($id) {
    //             return Crypt::decrypt($id);
    //         }, $request->language_ids ?? []);
    //         $session_ids = array_map(function ($id) {
    //             return Crypt::decrypt($id);
    //         }, $request->session_ids ?? []);
    //         $coupon_ids = array_map(function ($id) {
    //             return Crypt::decrypt($id);
    //         }, $request->coupon_ids ?? []);

    //         $included_section_descriptions = array_map(function ($desc) {
    //             return htmlspecialchars($desc, ENT_QUOTES);
    //         }, $request->included_section_descriptions ?? []);

    //         $assignment = [
    //             'course_id' => Crypt::decrypt($request->course),
    //             'position_order' => $position_order,
    //             'type_ids' => $type_ids,
    //             'language_ids' => $language_ids,
    //             'session_ids' => $session_ids,
    //             'coupon_ids' => $coupon_ids,
    //             'assignment_code' => $request->assignment_code,
    //             'assignment_title' => $request->assignment_title,
    //             'breadcrumb_headline' => $request->breadcrumb_headline,
    //             'assignment_quantity' => $request->assignment_quantity,
    //             'maximum_retail_price' => $request->maximum_retail_price,
    //             'selling_price' => $request->selling_price,
    //             'discount' => $request->discount,
    //             'additional_discount' => $request->additional_discount,
    //             'discount_offer_expiry' => $request->discount_offer_expiry,
    //             'assignment_expiry' => $request->assignment_expiry,
    //             'short_description' => htmlspecialchars($request->short_description, ENT_QUOTES),
    //             'download_info' => htmlspecialchars($request->download_info, ENT_QUOTES),
    //             'description' => htmlspecialchars($request->description, ENT_QUOTES),
    //             'cover_page_info' => htmlspecialchars($request->cover_page_info, ENT_QUOTES),
    //             'terms_conditions_text' => htmlspecialchars($request->terms_conditions_text, ENT_QUOTES),
    //             'why_choose_headline' => $request->why_choose_headline,
    //             // 'included_headline' => $request->included_headline,
    //             // 'included_icons' => $request->included_section_icons,
    //             // 'included_titles' => $request->included_section_titles,
    //             // 'included_descriptions' => $included_section_descriptions,
    //             'meta_title' => $request->meta_title,
    //             'meta_keyword' => $request->meta_keyword,
    //             'meta_description' => htmlspecialchars($request->meta_description, ENT_QUOTES)
    //         ];

    //         if (!empty($request->file('assignment_image'))) {
    //             $path = 'images/assignments/';
    //             $filePath = $this->storeImage($request->file('assignment_image'), $path);
    //             $assignment['assignment_image'] = $filePath;
    //         }
    //         if (!empty($request->file('question_paper_image'))) {
    //             $path = 'images/assignments/question_paper_images/';
    //             $filePath = $this->storeImage($request->file('question_paper_image'), $path);
    //             $assignment['question_paper_image'] = $filePath;
    //         }

    //         $new_assignment = Assignments::create($assignment);
    //         if ($new_assignment) {
    //             $lastAssignmentId = $new_assignment->id;

    //             $assignment_why_choose_res = false;
    //             try {
    //                 DB::beginTransaction(); // Start database transaction

    //                 if (empty($request->choose_contents)) {
    //                     DB::rollBack();
    //                     session()->flash('success', 'Assignment is inserted Successfully!');
    //                     return redirect()->route('manage.assignments', $request->course);
    //                 }

    //                 // Insert Why Choose Contents
    //                 if (!isset($request->choose_contents)) {
    //                     $assignment_why_choose_res = true;
    //                 }
    //                 if (!empty($request->choose_contents) && is_array($request->choose_contents)) {
    //                     $why_choose_contents = [];
    //                     $why_choose_order = AssignmentWhyChoose::where('assignment_id', $lastAssignmentId)->max('position_order');
    //                     $why_choose_position_order = ($why_choose_order !== null) ? $why_choose_order + 1 : 1;
    //                     $total_why_choose_contents = count($request->choose_contents);

    //                     for ($i = 0; $i < $total_why_choose_contents; $i++) {
    //                         $why_choose_data = [
    //                             'position_order' => $why_choose_position_order,
    //                             'assignment_id' => $lastAssignmentId,
    //                             'assignment_contents' => $request->choose_contents[$i] ?? null,
    //                         ];

    //                         $why_choose_contents[] = $why_choose_data; // Add to batch insert array
    //                         $why_choose_position_order++;
    //                     }

    //                     // Batch insert Why Choose Contents
    //                     AssignmentWhyChoose::insert($why_choose_contents);
    //                     $assignment_why_choose_res = true;
    //                 }

    //                 DB::commit(); // Commit transaction if everything is successful
    //             } catch (\Exception $e) {
    //                 DB::rollBack(); // Rollback transaction on error
    //                 // \Log::error('Error inserting subtreatment data: ' . $e->getMessage());
    //                 $assignment_why_choose_res = false;
    //             }


    //             $assignment_detail_res = false;
    //             try {
    //                 DB::beginTransaction(); // Start database transaction

    //                 if (empty($request->detail_titles)) {
    //                     DB::rollBack();
    //                     session()->flash('success', 'Assignment is inserted Successfully!');
    //                     return redirect()->route('manage.assignments', $request->course);
    //                 }

    //                 // Insert Assignment Detail
    //                 if (!isset($request->detail_titles)) {
    //                     $assignment_detail_res = true;
    //                 }
    //                 if (!empty($request->detail_titles) && is_array($request->detail_titles)) {
    //                     $assignment_detail_titles = [];
    //                     $detail_order = AssignmentDetails::where('assignment_id', $lastAssignmentId)->max('position_order');
    //                     $detail_position_order = ($detail_order !== null) ? $detail_order + 1 : 1;
    //                     $total_assignment_detail_titles = count($request->detail_titles);

    //                     for ($i = 0; $i < $total_assignment_detail_titles; $i++) {
    //                         $detail_data = [
    //                             'position_order' => $detail_position_order,
    //                             'assignment_id' => $lastAssignmentId,
    //                             'assignment_detail_titles' => $request->detail_titles[$i] ?? null,
    //                             'assignment_detail_texts' => $request->detail_texts[$i] ?? null,
    //                         ];

    //                         $assignment_detail_titles[] = $detail_data; // Add to batch insert array
    //                         $detail_position_order++;
    //                     }

    //                     // Batch insert Assignment Detail
    //                     AssignmentDetails::insert($assignment_detail_titles);
    //                     $assignment_detail_res = true;
    //                 }

    //                 DB::commit(); // Commit transaction if everything is successful
    //             } catch (\Exception $e) {
    //                 DB::rollBack(); // Rollback transaction on error
    //                 // \Log::error('Error inserting subtreatment data: ' . $e->getMessage());
    //                 $assignment_detail_res = false;
    //             }


    //             if ($assignment_why_choose_res && $assignment_detail_res) {
    //                 $request->session()->flash('success', 'Assignment is inserted Successfully!');
    //                 return redirect()->route('manage.assignments', $request->course);
    //             } else {
    //                 $request->session()->flash('error', 'Why Choose Insertion Error!');
    //                 return redirect()->route('add.assignment', $request->course);
    //             }
    //         } else {
    //             $request->session()->flash('error', 'Insertion Error!');
    //             return redirect()->route('add.assignment', $request->course);
    //         }
    //     } else {
    //         $all_assignment_types = Types::select('id', 'type_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_languages = Medium::select('id', 'language_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_sessions = EducationalSessions::select('id', 'session_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_coupons = Coupons::select('id', 'coupon', 'coupon_name')
    //             ->where([
    //                 'reference_type' => 'assignment',
    //                 'status' => 'active'
    //             ])
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $main_page = 'assignments_management';
    //         $currentPage = "manage_courses";
    //         return view('admin.assignment-ops', ['courseId' => $request->course, "all_assignment_types" => $all_assignment_types, "all_assignment_languages" => $all_assignment_languages, "all_assignment_sessions" => $all_assignment_sessions, "all_assignment_coupons" => $all_assignment_coupons, 'main_page' => $main_page, 'currentPage' => $currentPage]);
    //     }
    // }

    private function decryptArray(?array $items): array
    {
        return collect($items ?? [])
            ->map(fn($id) => Crypt::decrypt($id))
            ->all();
    }

    private function safe(?string $text): ?string
    {
        return $text ? htmlspecialchars($text, ENT_QUOTES) : null;
    }

    private function uploadFile(Request $request, string $field, string $path): ?string
    {
        if (!$request->hasFile($field)) {
            return null;
        }

        return $this->storeImage($request->file($field), $path);
    }

    public function addAssignment(Request $request)
    {
        if (!$request->isMethod('post')) {
            return $this->renderAssignmentForm($request);
        }

        $validated = $request->validate([
            'type_ids' => 'array|nullable',
            'language_ids' => 'array|nullable',
            'session_ids' => 'array|nullable',
            'coupon_ids' => 'array|nullable',

            'assignment_code' => 'required|string',
            'assignment_title' => 'required|string',
            'maximum_retail_price' => 'required|numeric',
            'selling_price' => 'required|numeric',

            'choose_contents' => 'array|nullable',
            'choose_contents.*' => 'nullable|string',

            'detail_titles' => 'array|nullable',
            'detail_titles.*' => 'nullable|string',

            'detail_texts' => 'array|nullable',
            'detail_texts.*' => 'nullable|string',
        ]);

        DB::beginTransaction();

        try {
            $position_order = (Assignments::max('position_order') ?? 0) + 1;

            $assignment = Assignments::create([
                'course_id' => Crypt::decrypt($request->course),
                'position_order' => $position_order,

                'type_ids' => $this->decryptArray($request->type_ids),
                'language_ids' => $this->decryptArray($request->language_ids),
                'session_ids' => $this->decryptArray($request->session_ids),
                'coupon_ids' => $this->decryptArray($request->coupon_ids),

                'assignment_code' => $request->assignment_code,
                'assignment_subject_name' => $request->assignment_subject_name,
                'assignment_title' => $request->assignment_title,

                'breadcrumb_headline' => $request->breadcrumb_headline,
                'assignment_quantity' => $request->assignment_quantity,

                'maximum_retail_price' => $request->maximum_retail_price,
                'selling_price' => $request->selling_price,
                'discount' => $request->discount,
                'additional_discount' => $request->additional_discount,
                'discount_offer_expiry' => $request->discount_offer_expiry,
                'assignment_expiry' => $request->assignment_expiry,

                'short_description' => $this->safe($request->short_description),
                'download_info' => $this->safe($request->download_info),
                'description' => $this->safe($request->description),
                'cover_page_info' => $this->safe($request->cover_page_info),
                // 'terms_conditions_text' => $this->safe($request->terms_conditions_text),

                'why_choose_headline' => $request->why_choose_headline,

                'meta_title' => $request->meta_title,
                'meta_keyword' => $request->meta_keyword,
                'meta_description' => $this->safe($request->meta_description),
            ]);

            // file uploads
            $assignment->update([
                'assignment_image' => $this->uploadFile($request, 'assignment_image', 'images/assignments/'),
                'question_paper_image' => $this->uploadFile($request, 'question_paper_image', 'images/assignments/question_paper_images/')
            ]);

            // why choose — batch insert
            if ($request->filled('choose_contents')) {
                $position = 1;

                $whyChoose = collect($request->choose_contents)
                    ->filter() // remove empty
                    ->map(function ($content) use ($assignment, &$position) {
                        return [
                            'assignment_id' => $assignment->id,
                            'position_order' => $position++,
                            'assignment_content' => $content,
                        ];
                    })->toArray();

                AssignmentWhyChoose::insert($whyChoose);
            }

            // assignment details — batch insert
            if ($request->filled('detail_titles')) {
                $position = 1;

                $details = collect($request->detail_titles)
                    ->map(function ($title, $index) use ($assignment, $request, &$position) {
                        return [
                            'assignment_id' => $assignment->id,
                            'position_order' => $position++,
                            'assignment_detail_title' => $title,
                            'assignment_detail_text' => $request->detail_texts[$index] ?? null,
                        ];
                    })->toArray();

                AssignmentDetails::insert($details);
            }

            DB::commit();

            return redirect()
                ->route('manage.assignments', $request->course)
                ->with('success', 'Assignment inserted successfully!');
        } catch (\Throwable $e) {
            DB::rollBack();

            Log::error('Assignment insert failed', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            return redirect()
                ->route('add.assignment', $request->course)
                ->with('error', 'Something went wrong while saving assignment.');
        }
    }

    private function renderAssignmentForm($request)
    {
        $all_assignment_types = Types::active()->get()->each(fn($i) => $i->encrypted_id = Crypt::encrypt($i->id));
        $all_assignment_languages = Medium::active()->get()->each(fn($i) => $i->encrypted_id = Crypt::encrypt($i->id));
        $all_assignment_sessions = EducationalSessions::active()->get()->each(fn($i) => $i->encrypted_id = Crypt::encrypt($i->id));
        $all_assignment_coupons = Coupons::where('reference_type', 'assignment')
            ->active()
            ->get()
            ->each(fn($i) => $i->encrypted_id = Crypt::encrypt($i->id));

        return view('admin.assignment-ops', [
            'courseId' => $request->course,
            'all_assignment_types' => $all_assignment_types,
            'all_assignment_languages' => $all_assignment_languages,
            'all_assignment_sessions' => $all_assignment_sessions,
            'all_assignment_coupons' => $all_assignment_coupons,
            'main_page' => 'assignments_management',
            'currentPage' => 'manage_courses',
        ]);
    }

    // public function editAssignment(Request $request)
    // {
    //     if ($request->isMethod('post')) {

    //         $request->validate([
    //             'type_ids' => 'array|nullable',
    //             'language_ids' => 'array|nullable',
    //             'session_ids' => 'array|nullable',
    //             'coupon_ids' => 'array|nullable',
    //             'assignment_code' => 'required|string',
    //             'assignment_title' => 'required|string',
    //             'maximum_retail_price' => 'required|numeric',
    //             'selling_price' => 'required|numeric',
    //             'included_section_icons' => 'array|nullable',
    //             'included_section_titles' => 'array|nullable',
    //             'included_section_descriptions' => 'array|nullable',
    //         ]);

    //         $type_ids = array_map(fn($id) => Crypt::decrypt($id), $request->type_ids ?? []);
    //         $language_ids = array_map(fn($id) => Crypt::decrypt($id), $request->language_ids ?? []);
    //         $session_ids = array_map(fn($id) => Crypt::decrypt($id), $request->session_ids ?? []);
    //         $coupon_ids = array_map(fn($id) => Crypt::decrypt($id), $request->coupon_ids ?? []);

    //         $included_section_descriptions = array_map(
    //             fn($desc) => htmlspecialchars($desc, ENT_QUOTES),
    //             $request->included_section_descriptions ?? []
    //         );

    //         $id = Crypt::decrypt($request->assignment);

    //         $assignment = Assignments::findOrFail($id);

    //         $assignment->course_id = Crypt::decrypt($request->course);
    //         $assignment->type_ids = $type_ids;
    //         $assignment->language_ids = $language_ids;
    //         $assignment->session_ids = $session_ids;
    //         $assignment->coupon_ids = $coupon_ids;
    //         $assignment->assignment_code = $request->assignment_code;
    //         $assignment->assignment_title = $request->assignment_title;
    //         $assignment->breadcrumb_headline = $request->breadcrumb_headline;
    //         $assignment->assignment_quantity = $request->assignment_quantity;
    //         $assignment->maximum_retail_price = $request->maximum_retail_price;
    //         $assignment->selling_price = $request->selling_price;
    //         $assignment->discount = $request->discount;
    //         $assignment->additional_discount = $request->additional_discount;
    //         $assignment->discount_offer_expiry = $request->discount_offer_expiry;
    //         $assignment->assignment_expiry = $request->assignment_expiry;
    //         $assignment->short_description = htmlspecialchars($request->short_description, ENT_QUOTES);
    //         $assignment->download_info = htmlspecialchars($request->download_info, ENT_QUOTES);
    //         $assignment->description = htmlspecialchars($request->description, ENT_QUOTES);
    //         $assignment->cover_page_info = htmlspecialchars($request->cover_page_info, ENT_QUOTES);
    //         // $assignment->terms_conditions_text = htmlspecialchars($request->terms_conditions_text, ENT_QUOTES);
    //         $assignment->why_choose_headline = $request->why_choose_headline;
    //         $assignment->meta_title = $request->meta_title;
    //         $assignment->meta_keyword = $request->meta_keyword;
    //         $assignment->meta_description = htmlspecialchars($request->meta_description, ENT_QUOTES);

    //         // Uploads
    //         if ($request->file('assignment_image')) {
    //             $path = 'images/assignments/';
    //             $assignment->assignment_image = $this->storeImage(
    //                 $request->file("assignment_image"),
    //                 $path,
    //                 $assignment->assignment_image
    //             );
    //         }

    //         if ($request->file('question_paper_image')) {
    //             $path = 'images/assignments/question_paper_images/';
    //             $assignment->question_paper_image = $this->storeImage(
    //                 $request->file("question_paper_image"),
    //                 $path,
    //                 $assignment->question_paper_image
    //             );
    //         }

    //         // -------------------------------
    //         // WHY CHOOSE — UPDATE | INSERT | DELETE
    //         // -------------------------------
    //         $existingWhyIds = AssignmentWhyChoose::where('assignment_id', $id)
    //             ->pluck('id')
    //             ->toArray();

    //         $submittedWhyIds = $request->choose_ids ?? [];
    //         $order = 1;

    //         foreach ($request->choose_contents ?? [] as $i => $content) {
    //             $rowId = $submittedWhyIds[$i] ?? null;

    //             if ($rowId) {
    //                 AssignmentWhyChoose::where('id', $rowId)->update([
    //                     'assignment_content' => $content,
    //                     'position_order' => $order++
    //                 ]);
    //             } else {
    //                 AssignmentWhyChoose::create([
    //                     'assignment_id' => $id,
    //                     'assignment_content' => $content,
    //                     'position_order' => $order++
    //                 ]);
    //             }
    //         }

    //         // $idsToDelete = array_diff($existingWhyIds, $submittedWhyIds);
    //         // if (!empty($idsToDelete)) {
    //         //     AssignmentWhyChoose::whereIn('id', $idsToDelete)->delete();
    //         // }

    //         // -------------------------------
    //         // DETAILS — UPDATE | INSERT | DELETE
    //         // -------------------------------
    //         $existingDetailIds = AssignmentDetails::where('assignment_id', $id)
    //             ->pluck('id')
    //             ->toArray();

    //         $submittedDetailIds = $request->detail_ids ?? [];
    //         $order = 1;

    //         foreach ($request->detail_titles ?? [] as $i => $title) {

    //             $rowId = $submittedDetailIds[$i] ?? null;

    //             if ($rowId) {
    //                 AssignmentDetails::where('id', $rowId)->update([
    //                     'assignment_detail_title' => $title,
    //                     'assignment_detail_text' => $request->detail_texts[$i] ?? null,
    //                     'position_order' => $order++
    //                 ]);
    //             } else {
    //                 AssignmentDetails::create([
    //                     'assignment_id' => $id,
    //                     'assignment_detail_title' => $title,
    //                     'assignment_detail_text' => $request->detail_texts[$i] ?? null,
    //                     'position_order' => $order++
    //                 ]);
    //             }
    //         }

    //         // $detailIdsToDelete = array_diff($existingDetailIds, $submittedDetailIds);
    //         // if (!empty($detailIdsToDelete)) {
    //         //     AssignmentDetails::whereIn('id', $detailIdsToDelete)->delete();
    //         // }

    //         // SAVE MASTER RECORD
    //         if ($assignment->save()) {
    //             $request->session()->flash('success', 'Assignment updated successfully!');
    //             return redirect()->route('manage.assignments', $request->course);
    //         }

    //         $request->session()->flash('error', 'Updation Error!');
    //         return redirect()->route('edit.assignment', [
    //             "course" => $request->course,
    //             "assignment" => $request->assignment
    //         ]);
    //     } else {

    //         // existing GET logic kept as-is
    //         $all_assignment_types = Types::select('id', 'type_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_languages = Medium::select('id', 'language_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_sessions = EducationalSessions::select('id', 'session_name')
    //             ->where('status', 'active')
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $all_assignment_coupons = Coupons::select('id', 'coupon', 'coupon_name')
    //             ->where([
    //                 'reference_type' => 'assignment',
    //                 'status' => 'active'
    //             ])
    //             ->get()
    //             ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

    //         $id = Crypt::decrypt($request->assignment);

    //         $assignment = Assignments::where('id', $id)->firstOrFail();
    //         $assignment->encrypted_id = $request->assignment;

    //         $included_section_icons = $assignment->included_icons;
    //         $included_section_titles = $assignment->included_titles;
    //         $included_section_descriptions = $assignment->included_descriptions;

    //         $main_page = 'assignments_management';
    //         $currentPage = "manage_courses";

    //         return view(
    //             'admin.assignment-ops',
    //             [
    //                 'courseId' => $request->course,
    //                 "all_assignment_types" => $all_assignment_types,
    //                 "all_assignment_languages" => $all_assignment_languages,
    //                 "all_assignment_sessions" => $all_assignment_sessions,
    //                 "all_assignment_coupons" => $all_assignment_coupons,
    //                 "assignment" => $assignment,
    //                 'main_page' => $main_page,
    //                 'currentPage' => $currentPage
    //             ],
    //             compact(
    //                 'included_section_icons',
    //                 'included_section_titles',
    //                 'included_section_descriptions'
    //             )
    //         );
    //     }
    // }

    function editAssignment(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'type_ids' => 'array|nullable',
                'language_ids' => 'array|nullable',
                'session_ids' => 'array|nullable',
                'coupon_ids' => 'array|nullable',
                'assignment_code' => 'required|string',
                'assignment_title' => 'required|string',
                'maximum_retail_price' => 'required|numeric',
                'selling_price' => 'required|numeric',
                'included_section_icons' => 'array|nullable',
                'included_section_titles' => 'array|nullable',
                'included_section_descriptions' => 'array|nullable',
            ], [
                'assignment_code.required' => 'Please provide a Assignment Code.',
                'assignment_code.string' => 'Assignment Code must be a string.',
                'assignment_title.required' => 'Please provide Assignment Title.',
                'assignment_title.string' => 'Assignment Title must be a string.',
                'maximum_retail_price.required' => 'Please provide MRP.',
                'maximum_retail_price.numeric' => 'MRP must be in numeric.',
                'selling_price.required' => 'Please provide Selling Price.',
                'selling_price.numeric' => 'Selling Price must be in numeric.',
            ]);

            $type_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->type_ids ?? []);
            $language_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->language_ids ?? []);
            $session_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->session_ids ?? []);
            $coupon_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->coupon_ids ?? []);

            $included_section_descriptions = array_map(function ($desc) {
                return htmlspecialchars($desc, ENT_QUOTES);
            }, $request->included_section_descriptions ?? []);

            $id = Crypt::decrypt($request->assignment);
            $assignment = Assignments::findOrFail($id);
            $assignment->course_id = Crypt::decrypt($request->course);
            $assignment->type_ids = $type_ids;
            $assignment->language_ids = $language_ids;
            $assignment->session_ids = $session_ids;
            $assignment->coupon_ids = $coupon_ids;
            $assignment->assignment_code = $request->assignment_code;
            $assignment->assignment_subject_name = $request->assignment_subject_name;
            $assignment->assignment_title = $request->assignment_title;
            $assignment->breadcrumb_headline = $request->breadcrumb_headline;
            $assignment->assignment_quantity = $request->assignment_quantity;
            $assignment->maximum_retail_price = $request->maximum_retail_price;
            $assignment->selling_price = $request->selling_price;
            $assignment->discount = $request->discount;
            $assignment->additional_discount = $request->additional_discount;
            $assignment->discount_offer_expiry = $request->discount_offer_expiry;
            $assignment->assignment_expiry = $request->assignment_expiry;
            $assignment->short_description = htmlspecialchars($request->short_description, ENT_QUOTES);
            $assignment->download_info = htmlspecialchars($request->download_info, ENT_QUOTES);
            $assignment->description = htmlspecialchars($request->description, ENT_QUOTES);
            $assignment->cover_page_info = htmlspecialchars($request->cover_page_info, ENT_QUOTES);
            // $assignment->terms_conditions_text = htmlspecialchars($request->terms_conditions_text, ENT_QUOTES);
            $assignment->why_choose_headline = $request->why_choose_headline;
            $assignment->meta_title = $request->meta_title;
            $assignment->meta_keyword = $request->meta_keyword;
            $assignment->meta_description = htmlspecialchars($request->meta_description, ENT_QUOTES);

            if (!empty($request->file('assignment_image'))) {
                $path = 'images/assignments/';
                $filePath = $this->storeImage($request->file("assignment_image"), $path, $assignment->assignment_image);
                $assignment->assignment_image = $filePath;
            }
            if (!empty($request->file('question_paper_image'))) {
                $path = 'images/assignments/question_paper_images/';
                $filePath = $this->storeImage($request->file("question_paper_image"), $path, $assignment->question_paper_image);
                $assignment->question_paper_image = $filePath;
            }

            if ($assignment->save()) {

                $assignment_why_choose_res = false;
                try {
                    DB::beginTransaction(); // Start database transaction

                    if (empty($request->choose_ids)) {
                        DB::rollBack();
                        $request->session()->flash('success', 'Assignment is updated Successfully!');
                        return redirect()->route('manage.assignments', $request->course);
                    }

                    // Handle choose_ids
                    if (!isset($request->choose_ids)) {
                        $assignment_why_choose_res = true;
                    } elseif (!empty($request->choose_ids) && is_array($request->choose_ids)) {
                        $assignment_choose_ids = [];
                        $assignment_why_choose_order = AssignmentWhyChoose::where('assignment_id', $id)->max('position_order');
                        $assignment_why_choose_position_order = ($assignment_why_choose_order !== null) ? $assignment_why_choose_order + 1 : 1;
                        foreach ($request->choose_ids as $i => $assignment_why_choose) {
                            if (!empty($assignment_why_choose)) {
                                // Update existing Assignment Why Choose
                                $assignment_why_choose_id = Crypt::decrypt($assignment_why_choose);
                                $ad_assignment_why_choose = AssignmentWhyChoose::find($assignment_why_choose_id);
                                if ($ad_assignment_why_choose) {
                                    $ad_assignment_why_choose->assignment_content = $request->choose_contents[$i] ?? null;
                                    $ad_assignment_why_choose->save();
                                }
                            } else {
                                // Prepare new assignment_why_choose data for batch insert
                                $assignment_choose_ids[] = [
                                    'position_order' => $assignment_why_choose_position_order,
                                    'assignment_id' => $id,
                                    'assignment_content' => $request->choose_contents[$i] ?? null,
                                ];
                                $assignment_why_choose_position_order++;
                            }
                        }

                        // Batch insert new assignment_choose_ids
                        if (!empty($assignment_choose_ids)) {
                            AssignmentWhyChoose::insert($assignment_choose_ids);
                        }

                        $assignment_why_choose_res = true;
                    }

                    DB::commit(); // Commit transaction if everything is successful
                } catch (\Exception $e) {
                    DB::rollBack(); // Rollback transaction on error
                    // \Log::error('Error updating subtreatment data: ' . $e->getMessage());
                    $assignment_why_choose_res = false;
                }

                $assignment_detail_res = false;
                try {
                    DB::beginTransaction(); // Start database transaction

                    if (empty($request->detail_ids)) {
                        DB::rollBack();
                        $request->session()->flash('success', 'Assignment is updated Successfully!');
                        return redirect()->route('manage.assignments', $request->course);
                    }

                    // Handle detail_ids
                    if (!isset($request->detail_ids)) {
                        $assignment_detail_res = true;
                    } elseif (!empty($request->detail_ids) && is_array($request->detail_ids)) {
                        $assignment_detail_ids = [];
                        $assignment_detail_order = AssignmentDetails::where('assignment_id', $id)->max('position_order');
                        $assignment_detail_position_order = ($assignment_detail_order !== null) ? $assignment_detail_order + 1 : 1;
                        foreach ($request->detail_ids as $i => $assignment_detail) {
                            if (!empty($assignment_detail)) {
                                // Update existing Assignment Why Choose
                                $assignment_detail_id = Crypt::decrypt($assignment_detail);
                                $ad_assignment_detail = AssignmentDetails::find($assignment_detail_id);
                                if ($ad_assignment_detail) {
                                    $ad_assignment_detail->assignment_detail_title = $request->detail_titles[$i] ?? null;
                                    $ad_assignment_detail->assignment_detail_text = $request->detail_texts[$i] ?? null;
                                    $ad_assignment_detail->save();
                                }
                            } else {
                                // Prepare new assignment_detail data for batch insert
                                $assignment_detail_ids[] = [
                                    'position_order' => $assignment_detail_position_order,
                                    'assignment_id' => $id,
                                    'assignment_detail_title' => $request->detail_titles[$i] ?? null,
                                    'assignment_detail_text' => $request->detail_texts[$i] ?? null,
                                ];
                                $assignment_detail_position_order++;
                            }
                        }

                        // Batch insert new assignment_detail_ids
                        if (!empty($assignment_detail_ids)) {
                            AssignmentDetails::insert($assignment_detail_ids);
                        }

                        $assignment_detail_res = true;
                    }

                    DB::commit(); // Commit transaction if everything is successful
                } catch (\Exception $e) {
                    DB::rollBack(); // Rollback transaction on error
                    // \Log::error('Error updating subtreatment data: ' . $e->getMessage());
                    $assignment_detail_res = false;
                }

                if ($assignment_why_choose_res && $assignment_detail_res) {
                    $request->session()->flash('success', 'Assignment is updated Successfully!');
                    return redirect()->route('manage.assignments', $request->course);
                } else {
                    session()->flash('error', 'Error updating why choose data!');
                    return redirect()->back();
                }
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.assignment', ["course" => $request->course, "assignment" => $request->assignment]);
            }
        } else {
            $all_assignment_types = Types::select('id', 'type_name')
                ->where('status', 'active')
                ->get()
                ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

            $all_assignment_languages = Medium::select('id', 'language_name')
                ->where('status', 'active')
                ->get()
                ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

            $all_assignment_sessions = EducationalSessions::select('id', 'session_name')
                ->where('status', 'active')
                ->get()
                ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

            $all_assignment_coupons = Coupons::select('id', 'coupon', 'coupon_name')
                ->where([
                    'reference_type' => 'assignment',
                    'status' => 'active'
                ])
                ->get()
                ->each(fn($item) => $item->encrypted_id = Crypt::encrypt($item->id));

            $id = Crypt::decrypt($request->assignment);
            $assignment = Assignments::where('id', $id)->firstOrFail();
            $assignment->encrypted_id = $request->assignment;

            $included_section_icons = $assignment->included_icons;
            $included_section_titles = $assignment->included_titles;
            $included_section_descriptions = $assignment->included_descriptions;

            $main_page = 'assignments_management';
            $currentPage = "manage_courses";
            return view('admin.assignment-ops', ['courseId' => $request->course, "all_assignment_types" => $all_assignment_types, "all_assignment_languages" => $all_assignment_languages, "all_assignment_sessions" => $all_assignment_sessions, "all_assignment_coupons" => $all_assignment_coupons, "assignment" => $assignment, 'main_page' => $main_page, 'currentPage' => $currentPage], compact('included_section_icons', 'included_section_titles', 'included_section_descriptions'));
        }
    }

    // function getAllCategoriesAndCount($type)
    // {
    //     $all_categories = Categories::select('id', 'category_headline', 'category_url')->where(['reference_type' => $type, "status" => 'active'])->orderBy('position_order')->get();
    //     foreach ($all_categories as $category) {
    //         $category->blog_count = Blogs::where('category_id', $category->id)->count();
    //     }

    //     return $all_categories;
    // }

    // function uploadBlogImages(Request $request) {
    //     if(session()->has('user')) {
    //         $locations = [];

    //         if ($request->hasFile('file')) {
    //             print_r($request->file('file'));
    //             foreach ($request->file('file') as $file) {
    //                 $path = $file->store('admin-assets/images/blog-textareas/', 'public');
    //                 $locations[] = Storage::url($path);
    //             }

    //             return response()->json(['locations' => $locations]);
    //         }

    //         return response()->json(['error' => 'No files uploaded'], 400);
    //     }
    //     else {
    //         return redirect()->route('login');
    //     }
    // }


    // function editBlogContent(Request $request) {
    //     if(session()->has('user')) {
    //         if($request->isMethod('post')) {
    //             $request->validate([
    //                 'content_headline' => 'required|string',
    //             ], [
    //                 'content_headline.required' => 'Please provide a headline for the blog content.',
    //                 'content_headline.string' => 'Blog-Content headline must be a string.',
    //             ]);

    //             $id = 1;
    //             $blog_content = BlogContent::findOrFail($id);
    //             // $blog_content->position_order = $request->position_order;
    //             $blog_content->content_headline = $request->content_headline;
    //             $blog_content->description = htmlspecialchars($request->description, ENT_QUOTES);

    //             if(!empty($request->file('content_image'))) {
    //                 if(!empty($blog_content->content_image)) {
    //                     Storage::disk('public')->delete($blog_content->content_image);
    //                 }
    //                 $path = $request->file('content_image')->store('admin-assets/images/blogs/', 'public');
    //                 $blog_content->content_image = $path;
    //             }

    //             if($blog_content->save()) {
    //                 $request->session()->flash('success', 'Blog-Content is updated Successfully!');
    //                 return redirect()->route('edit.blog.content');
    //             }
    //             else {
    //                 $request->session()->flash('error', 'Updation Error!');
    //                 return redirect()->route('edit.blog.content');
    //             }
    //         }
    //         else {
    //             $id = 1;
    //             $blog_content = BlogContent::findOrFail($id);

    //             $main_page = 'blogs_management';
    //             $currentPage = "blog_content";
    //             return view('admin.blog_content-ops', ["blog_content" => $blog_content, 'main_page' => $main_page, 'currentPage' => $currentPage]);
    //         }
    //     }
    //     else {
    //         return redirect()->route('login');
    //     }
    // }

    public function getAssignmentWhyChoose(Request $request)
    {
        $assignment_id = Crypt::decrypt($request->assignment);
        $adwhychooses = AssignmentWhyChoose::select('id', 'assignment_content', 'status')->where('assignment_id', $assignment_id)->get();

        $all_whychooses = $adwhychooses->map(function ($adwhychoose) {
            return [
                'choose_id' => Crypt::encrypt($adwhychoose->id),
                'choose_content' => $adwhychoose->assignment_content,
            ];
        });

        return response()->json($all_whychooses);
    }

    public function deleteWhyChoose(Request $request)
    {
        $choose_id = Crypt::decrypt($request->choose);
        $assignment_why_choose = AssignmentWhyChoose::find($choose_id);
        if ($assignment_why_choose->delete()) {
            return 1;
        } else {
            return 0;
        }
    }

    public function getAssignmentDetails(Request $request)
    {
        $assignment_id = Crypt::decrypt($request->assignment);
        $ad_details = AssignmentDetails::select('id', 'assignment_detail_title', 'assignment_detail_text', 'status')->where('assignment_id', $assignment_id)->get();

        $all_details = $ad_details->map(function ($ad_detail) {
            return [
                'detail_id' => Crypt::encrypt($ad_detail->id),
                'detail_title' => $ad_detail->assignment_detail_title,
                'detail_text' => $ad_detail->assignment_detail_text,
            ];
        });

        return response()->json($all_details);
    }

    public function deleteAssignmentDetails(Request $request)
    {
        $detail_id = Crypt::decrypt($request->detail);
        $assignment_detail = AssignmentWhyChoose::find($detail_id);
        if ($assignment_detail->delete()) {
            return 1;
        } else {
            return 0;
        }
    }
}
