<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Banners;
use App\Models\Admin\Images;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;

class BannersController extends Controller
{
    function removeImage($existed_file)
    {
        unlink(public_path($existed_file));
        return;
    }

    function storeImage($file, $path, $existed_file = "")
    {
        if (!empty($existed_file) && file_exists(public_path($existed_file))) {
            $this->removeImage($existed_file);
        }

        $fileName = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        $filePath = $path . $fileName;
        $file->move(public_path($path), $fileName);
        return $filePath;
    }

    function manageBanners()
    {
        $banners = Banners::select('id', 'position_order', 'banner_headline', 'banner_image', 'status')->orderBy('position_order')->get();
        foreach ($banners as $banner) {
            $banner->encrypted_id = Crypt::encrypt($banner->id);
        }
        $model = Crypt::encrypt('Banners');
        $currentPage = "manage_banners";
        return view('admin.manage_banners', ['bannersData' => $banners, 'model' => $model, "currentPage" => $currentPage]);
    }

    function addBanner(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'banner_headline' => 'required',
                'banner_image' => 'required|image|mimes:jpeg,png,jpg,gif,webp,svg,bmp,tiff|max:5120',
                // 'banner_icons.*' => 'image|mimes:jpeg,png,jpg,gif,webp,svg,bmp,tiff|max:5120'
            ], [
                'banner_headline.required' => 'Please upload a banner headline.',
                'banner_image.required' => 'Please upload a banner image.',
                'banner_image.image' => 'The banner must be a valid image file.',
                'banner_image.mimes' => 'Allowed banner image formats: jpeg, png, jpg, gif, webp, svg, bmp, tiff.',
                'banner_image.max' => 'The banner image size should not exceed 5MB.',
                // 'banner_icons.*.image' => 'Each banner icon must be a valid image file.',
                // 'banner_icons.*.mimes' => 'Allowed icon formats: jpeg, png, jpg, gif, webp, svg, bmp, tiff.',
                // 'banner_icons.*.max' => 'Each banner icon should not exceed 5MB.'
            ]);

            $order = Banners::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $banner = [
                'position_order' => $position_order,
                'banner_headline' => $request->banner_headline,
                'banner_title' => $request->banner_title,
                'description' => htmlspecialchars($request->description, ENT_QUOTES),
                'button_name' => $request->button_name,
                'button_link' => $request->button_link,
                'other_button_name' => $request->other_button_name,
                'other_button_link' => $request->other_button_link
            ];

            $path = 'images/banners/';
            $filePath = $this->storeImage($request->file('banner_image'), $path);
            $banner['banner_image'] = $filePath;

            $banner_created = Banners::create($banner);
            if ($banner_created) {
                // if ($request->hasFile('banner_icons')) {
                //     $path = 'images/banners/';
                //     foreach ($request->file('banner_icons') as $icon) {
                //         $fileName = time() . '_' . uniqid() . '.' . $icon->getClientOriginalExtension();
                //         $filePath = $path . $fileName;
                //         $icon->move(public_path($path), $fileName);

                //         Images::create([
                //             'reference_id' => $banner_created->id,
                //             'reference_type' => 'banner',
                //             'file_type' => 'banner_icon',
                //             'file_name' => $fileName,
                //             'file_path' => $filePath,
                //         ]);
                //     }
                // }
                $request->session()->flash('success', 'Banner is inserted Successfully!');
                return redirect()->route('manage.banners');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.banner');
            }
        } else {
            $currentPage = "manage_banners";
            return view('admin.banner-ops', ["currentPage" => $currentPage]);
        }
    }

    function editBanner(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'banner_headline' => 'required',
                'banner_image' => 'image|mimes:jpeg,png,jpg,gif,webp,svg,bmp,tiff|max:5120',
                // 'banner_icons.*' => 'image|mimes:jpeg,png,jpg,gif,webp,svg,bmp,tiff|max:5120'
            ], [
                'banner_headline.required' => 'Please upload a banner headline.',
                'banner_image.image' => 'The banner must be a valid image file.',
                'banner_image.mimes' => 'Allowed banner image formats: jpeg, png, jpg, gif, webp, svg, bmp, tiff.',
                'banner_image.max' => 'The banner image size should not exceed 5MB.',
                // 'banner_icons.*.image' => 'Each banner icon must be a valid image file.',
                // 'banner_icons.*.mimes' => 'Allowed icon formats: jpeg, png, jpg, gif, webp, svg, bmp, tiff.',
                // 'banner_icons.*.max' => 'Each banner icon should not exceed 5MB.'
            ]);

            $id = Crypt::decrypt($request->banner);
            $banner = Banners::findOrFail($id);
            $banner->banner_headline = $request->banner_headline;
            $banner->banner_title = $request->banner_title;
            $banner->description = htmlspecialchars($request->description, ENT_QUOTES);
            $banner->button_name = $request->button_name;
            $banner->button_link = $request->button_link;
            $banner->other_button_name = $request->other_button_name;
            $banner->other_button_link = $request->other_button_link;

            if (!empty($request->file('banner_image'))) {
                $path = 'images/banners/';
                $filePath = $this->storeImage($request->file("banner_image"), $path, $banner->banner_image);
                $banner->banner_image = $filePath;
            }

            if ($banner->save()) {
                // if ($request->hasFile('banner_icons')) {
                //     $existingIcons = Images::where(["reference_id" => $id, "reference_type" => 'banner', "file_type" => 'banner_icon'])->get();
                //     foreach ($existingIcons as $existingIcon) {
                //         $existingIconPath = public_path($existingIcon->file_path);
                //         if (file_exists($existingIconPath)) {
                //             unlink($existingIconPath);
                //         }
                //         $existingIcon->delete();
                //     }
                //     $path = 'images/banners/';
                //     foreach ($request->file('banner_icons') as $icon) {
                //         $fileName = time() . '_' . uniqid() . '.' . $icon->getClientOriginalExtension();
                //         $filePath = $path . $fileName;
                //         $icon->move(public_path($path), $fileName);

                //         Images::create([
                //             'reference_id' => $id,
                //             'reference_type' => 'banner',
                //             'file_type' => 'banner_icon',
                //             'file_name' => $fileName,
                //             'file_path' => $filePath,
                //         ]);
                //     }
                // }
                $request->session()->flash('success', 'Banner is updated Successfully!');
                return redirect()->route('manage.banners');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.banner', $request->banner);
            }
        } else {
            $id = Crypt::decrypt($request->banner);
            $banner = Banners::where('id', $id)->firstOrFail();
            $banner->encrypted_id = $request->banner;
            // $banner->banner_icons = Images::where(["reference_id" => $id, "reference_type" => 'banner', "file_type" => 'banner_icon'])->get(["id", "file_path"]);
            $currentPage = "manage_banners";
            return view('admin.banner-ops', ["banner" => $banner, "currentPage" => $currentPage]);
        }
    }

    function getAllBanners()
    {
        $banners = Banners::where('status', 'active')->orderBy('position_order')->get();
        // foreach ($banners as $banner) {
        //     $banner->icons = Images::where('reference_id', $banner->id)->get();
        // }

        return $banners;
    }
}
