<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Coupons;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;

class CouponsController extends Controller
{
    function manageCoupons()
    {
        $coupons = Coupons::select('id', 'reference_type', 'position_order', 'coupon_name', 'coupon', 'coupon_validity', 'status')->orderBy('position_order')->get();
        foreach ($coupons as $coupon) {
            $coupon->encrypted_id = Crypt::encrypt($coupon->id);
        }

        $currentPage = "manage_coupons";
        $model = Crypt::encrypt('Coupons');
        return view('admin.manage_coupons', ['couponsData' => $coupons, 'model' => $model, 'currentPage' => $currentPage]);
    }

    function addCoupon(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'reference_type' => 'required|string',
                'coupon_name' => 'required|string',
            ], [
                'reference_type.required' => 'Please provide reference for the Coupon.',
                'coupon_name.required' => 'Please provide a Coupon Name.',
                'coupon_name.string' => 'Coupon Name must be a string.',
            ]);

            $order = Coupons::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $lastNumber = Coupons::max('id') ?? 0;
            $nextNumber = $lastNumber + 1;
            $letters = strtoupper(Str::random(3));

            $coupon_code = $nextNumber . $letters;
            $coupon_validity = Carbon::now('Asia/Kolkata')->addHour();

            $coupon = [
                'reference_type' => $request->reference_type,
                'position_order' => $position_order,
                'coupon_name' => $request->coupon_name,
                'coupon' => $coupon_code,
                'coupon_relevant_text' => $request->coupon_relevant_text,
                'coupon_validity' => $coupon_validity
            ];

            if (Coupons::create($coupon)) {
                $request->session()->flash('success', 'Coupon is inserted Successfully!');
                return redirect()->route('manage.coupons');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.coupon');
            }
        } else {
            $currentPage = "manage_coupons";
            return view('admin.coupon-ops', ['currentPage' => $currentPage]);
        }
    }

    function editCoupon(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'reference_type' => 'required|string',
                'coupon_name' => 'required|string',
            ], [
                'reference_type.required' => 'Please provide reference for the Coupon.',
                'coupon_name.required' => 'Please provide a Coupon Name.',
                'coupon_name.string' => 'Coupon Name must be a string.',
            ]);

            $id = Crypt::decrypt($request->coupon);
            $coupon = Coupons::findOrFail($id);
            $coupon->reference_type = $request->reference_type;
            $coupon->coupon_name = $request->coupon_name;
            $coupon->coupon_relevant_text = $request->coupon_relevant_text;

            if ($coupon->save()) {
                $request->session()->flash('success', 'Coupon is updated Successfully!');
                return redirect()->route('manage.coupons');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.coupon', ["coupon" => $request->coupon]);
            }
        } else {
            $id = Crypt::decrypt($request->coupon);
            $coupon = Coupons::where('id', $id)->firstOrFail();
            $coupon->encrypted_id = $request->coupon;

            $currentPage = "manage_coupons";
            return view('admin.coupon-ops', ["coupon" => $coupon, 'currentPage' => $currentPage]);
        }
    }
}
