<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Courses;
use App\Models\Customers;
use App\Models\Files;
use App\Models\Modules;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class DataController extends Controller
{
    public function manageGuestData()
    {
        $modules = Modules::select('id', 'email_to', 'your_email', 'passcode', 'sharable_link', 'message', 'total_clicks', 'validity', 'status')->orderByDesc('id')->where('customer_id', 0)->get();
        foreach ($modules as $module) {
            $module->encrypted_id = Crypt::encrypt($module->id);
            $module->is_valid = $module->validity && Carbon::parse($module->validity, 'Asia/Kolkata')->isPast() ? 'Invalid' : 'Valid';
        }

        $currentPage = "manage_guest_users_data";
        return view('admin.manage_users_data', ['modulesData' => $modules, 'currentPage' => $currentPage]);
    }

    public function viewFiles(Request $request)
    {
        $module_id = Crypt::decrypt($request->module_id);
        $currentPage = "manage_guest_users_data";
        $customer = null;
        if (isset($request->customer_enc) && !empty($request->customer_enc)) {
            $customer_id = Crypt::decrypt($request->customer_enc);
            $customer = Customers::find($customer_id);
            $customer->encrypted_id = $request->customer_enc;
            $currentPage = "manage_customers";
        }
        $files = Files::select('id', 'original_name', 'encrypted_name', 'total_downloads', 'file_status')->where('module_id', $module_id)->orderByDesc('id')->get();
        foreach ($files as $file) {
            $file->encrypted_id = Crypt::encrypt($file->id);
        }

        return view('admin.view_files_data', ['customer' => $customer, 'filesData' => $files, 'currentPage' => $currentPage]);
    }

    public function getCsvData()
    {
        $path = public_path('data-new/ignou_course.csv');

        if (! file_exists($path)) {
            return "CSV file not found.";
        }

        $rows = [];

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENT CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) {
                    continue;
                }

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));

                $row = array_combine($headers, $row);

                $rows[] = $row;
            }

            fclose($handle);
        }

        // // get only the course_type column
        // $types = array_column($rows, 'course_type');

        // // keep only unique values
        // $uniqueTypes = array_unique($types);

        // // re-index and print
        // dd(array_values($uniqueTypes));

        /*
        |--------------------------------------------------------------------------
        | 3️⃣ FILTER
        |--------------------------------------------------------------------------
        */

        // $filtered = array_filter($rows, function ($row) {
        //     return ($row['assignment_type'] ?? null) === 'Solved_PDF' &&
        //         ($row['assignment_language'] ?? null) === 'English';
        // });

        // transform
        $transformed = array_map(function ($row) {

            $row['category_id'] = match ($row['course_type'] ?? null) {
                'Bachelor Degree'      => 2,
                'Master Degree'        => 3,
                'P_G_Diploma'          => 6,
                'Diploma'              => 5,
                'certificate_Diploma'  => 4,
                default                => null
            };

            return $row;
        }, $rows);

        // prepare only fields your table needs
        $insertData = [];
        $position_order = Courses::max('position_order') ?? 0;

        foreach ($transformed as $row) {

            if (!($row['course_code'] ?? null)) {
                continue; // skip invalid row
            }

            // avoid duplicate insert (based on course_code)
            if (Courses::where('course_code', $row['course_code'])->exists()) {
                continue;
            }

            $position_order++;

            $insertData[] = [
                'category_id'  => $row['category_id'] ?? null,
                'position_order'  => $position_order,
                'course_icon'  => 'fa-folder-open',
                'course_name'  => $row['course_title'] ?? null,
                'course_headline'  => $row['site_title'] ?? null,
                'course_code'  => $row['course_code'] ?? null,
                'breadcrumb_headline'  => $row['site_title'] ?? null,
                'course_duration'    => ($row['course_in_year'] ?? null) === '' 
                                            ? null 
                                            : $row['course_in_year'],

                'course_semester'    => ($row['course_semester'] ?? null) === '' 
                                            ? null 
                                            : $row['course_semester'],
                'meta_keyword'  => $row['meta_tags'] ?? null,
                'meta_description'  => htmlspecialchars($row['meta_description'], ENT_QUOTES) ?? null,
            ];
        }

        // echo '<pre>';
        // print_r(array_values($insertData));
        // echo '</pre>';

        // chunk insert (fast)
        foreach (array_chunk($insertData, 500) as $chunk) {
            Courses::insert($chunk);
        }

        return "Imported: " . count($insertData) . " courses.";

        // echo '<pre>';
        // print_r(array_values($transformed));
        // echo '</pre>';
    }
}
