<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Pricing;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class PricingController extends Controller
{
    public function managePlans()
    {
        $plans = Pricing::select('id', 'position_order', 'plan_name', 'plan_image', 'plan_price', 'status')->get();
        foreach ($plans as $plan) {
            $plan->encrypted_id = Crypt::encrypt($plan->id);
        }
        $currentPage = "manage_plans";
        $model = Crypt::encrypt('Pricing');
        return view('admin.manage_plans', ['plansData' => $plans, 'model' => $model, 'currentPage' => $currentPage]);
    }

    public function addPlan(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'plan_name' => 'required|string',
                'plan_storage_limit' => 'required|numeric',
            ]);

            $plan_order = Pricing::max('position_order');
            $position_order = ($plan_order !== null) ? $plan_order + 1 : 1;

            $plan = [
                'position_order' => $position_order,
                'plan_name' => $request->plan_name,
                'plan_category' => $request->plan_category,
                'plan_price' => $request->plan_price,
                'plan_storage_limit' => $request->plan_storage_limit,
                'plan_price_base' => $request->plan_price_base,
                'short_description' => htmlspecialchars($request->short_description, ENT_QUOTES),
                'description' => htmlspecialchars($request->description, ENT_QUOTES),
            ];

            if (!empty($request->file('plan_image'))) {
                $path = 'images/plans/';
                $filePath = $this->storeImage($request->file('plan_image'), $path);
                $plan['plan_image'] = $filePath;
            }

            if (Pricing::create($plan)) {
                $request->session()->flash('success', 'Plan is inserted Successfully!');
                return redirect()->route('manage.plans');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.plan');
            }
        } else {
            $currentPage = "manage_plans";
            return view('admin.plan-ops', ['currentPage' => $currentPage]);
        }
    }

    public function editPlan(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'plan_name' => 'required|string',
                'plan_storage_limit' => 'required|numeric',
            ]);

            $id = Crypt::decrypt($request->plan);
            $plan = Pricing::findOrFail($id);
            $plan->plan_name = $request->plan_name;
            $plan->plan_category = $request->plan_category;
            $plan->plan_price = $request->plan_price;
            $plan->plan_price_base = $request->plan_price_base;
            $plan->plan_storage_limit = $request->plan_storage_limit;
            $plan->short_description = htmlspecialchars($request->short_description, ENT_QUOTES);
            $plan->description = htmlspecialchars($request->description, ENT_QUOTES);

            if (!empty($request->file('plan_image'))) {
                $path = 'images/plans/';
                $filePath = $this->storeImage($request->file("plan_image"), $path, $plan->plan_image);
                $plan->plan_image = $filePath;
            }

            if ($plan->save()) {
                $request->session()->flash('success', 'Plan is updated Successfully!');
                return redirect()->route('manage.plans');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.plan', $request->plan);
            }
        } else {
            $id = Crypt::decrypt($request->plan);
            $plan = Pricing::where('id', $id)->firstOrFail();
            $plan->encrypted_id = $request->plan;
            $currentPage = "manage_plans";
            return view('admin.plan-ops', ["plan" => $plan, 'currentPage' => $currentPage]);
        }
    }
}
