<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Subjects;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class SubjectsController extends Controller
{
    // function checkSubjectLink($subject_url, $encrypted_id = "")
    // {
    //     $subject_url = str_replace(['/', ' '], '-', $subject_url);
    //     $subject_url = preg_replace('/[^a-z0-9-]+/', '-', $subject_url);
    //     $subject_url = trim($subject_url, '-');
    //     $subject_url = preg_replace('/-+/', '-', $subject_url);
    //     $original_link = $subject_url;

    //     $id = (isset($encrypted_id) && !empty($encrypted_id)) ? Crypt::decrypt($encrypted_id) : 0;
    //     $suffix = 1;
    //     do {
    //         $count = $id != 0 ? Subjects::where('course_url', $subject_url)->where('id', '!=', $id)->count() : Subjects::where('course_url', $subject_url)->count();

    //         if ($count > 0) {
    //             $subject_url = $original_link . '-' . $suffix;
    //             $suffix++;
    //         } else {
    //             break;
    //         }
    //     } while (true);

    //     return $subject_url;
    // }

    function manageSubjects()
    {
        $subjects = Subjects::select('id', 'position_order', 'subject_code', 'subject_name', 'subject_headline', 'subject_icon', 'status')->orderBy('position_order')->get();
        foreach ($subjects as $subject) {
            $subject->encrypted_id = Crypt::encrypt($subject->id);
        }

        $main_page = 'assignments_management';
        $currentPage = "manage_subjects";
        $model = Crypt::encrypt('Subjects');
        return view('admin.manage_subjects', ['subjectsData' => $subjects, 'model' => $model, 'main_page' => $main_page, 'currentPage' => $currentPage]);
    }

    function addSubject(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'category_id' => 'required|string',
                'subject_name' => 'required|string',
                // 'course_headline' => 'required|string',
                'subject_code' => 'required|string',
            ], [
                'category_id.required' => 'Please provide the Category.',
                'subject_name.required' => 'Please provide a Course Name.',
                'subject_name.string' => 'Course Name must be a string.',
                // 'course_headline.required' => 'Please provide Course Headline.',
                // 'course_headline.string' => 'Course Headline must be a string.',
                'subject_code.required' => 'Please provide Course Code.',
                'subject_code.string' => 'Course Code must be a string.',
            ]);

            $order = Subjects::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $course_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->course_ids ?? []);

            $subject = [
                'course_ids' => $course_ids,
                'position_order' => $position_order,
                'subject_name' => $request->subject_name,
                'subject_code' => $request->subject_code,
                'course_year' => $request->course_year,
                'course_semester' => $request->course_semester,
                'short_description' => htmlspecialchars($request->short_description, ENT_QUOTES),
                'description' => htmlspecialchars($request->description, ENT_QUOTES),
                'breadcrumb_headline' => $request->breadcrumb_headline,
                'subject_icon' => $request->subject_icon,
                'meta_title' => $request->meta_title,
                'meta_keyword' => $request->meta_keyword,
                'meta_description' => htmlspecialchars($request->meta_description, ENT_QUOTES)
            ];

            if (Subjects::create($subject)) {
                $request->session()->flash('success', 'Subject is inserted Successfully!');
                return redirect()->route('manage.subjects', $request->course);
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.subject', $request->course);
            }
        } else {
            $main_page = 'assignments_management';
            $currentPage = "manage_subjects";
            return view('admin.subject-ops', ['main_page' => $main_page, 'currentPage' => $currentPage]);
        }
    }

    function editSubject(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'category_id' => 'required|string',
                'subject_name' => 'required|string',
                // 'course_headline' => 'required|string',
                'subject_code' => 'required|string',
            ], [
                'category_id.required' => 'Please provide the Category.',
                'subject_name.required' => 'Please provide a Course Name.',
                'subject_name.string' => 'Course Name must be a string.',
                // 'course_headline.required' => 'Please provide Course Headline.',
                // 'course_headline.string' => 'Course Headline must be a string.',
                'subject_code.required' => 'Please provide Course Code.',
                'subject_code.string' => 'Course Code must be a string.',
            ]);

            $course_ids = array_map(function ($id) {
                return Crypt::decrypt($id);
            }, $request->course_ids ?? []);

            $id = Crypt::decrypt($request->subject);
            $subject = Subjects::findOrFail($id);
            $subject->course_ids = $course_ids;
            $subject->subject_name = $request->subject_name;
            $subject->subject_code = $request->subject_code;
            $subject->course_year = $request->course_year;
            $subject->course_semester = $request->course_semester;
            $subject->short_description = htmlspecialchars($request->short_description, ENT_QUOTES);
            $subject->description = htmlspecialchars($request->description, ENT_QUOTES);
            $subject->breadcrumb_headline = $request->breadcrumb_headline;
            $subject->subject_icon = $request->subject_icon;
            $subject->meta_title = $request->meta_title;
            $subject->meta_keyword = $request->meta_keyword;
            $subject->meta_description = htmlspecialchars($request->meta_description, ENT_QUOTES);

            if ($subject->save()) {
                $request->session()->flash('success', 'Subject is updated Successfully!');
                return redirect()->route('manage.subjects', $request->course);
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.subject', ["course" => $request->course, "subject" => $request->subject]);
            }
        } else {
            $id = Crypt::decrypt($request->subject);
            $subject = Subjects::where('id', $id)->firstOrFail();
            $subject->encrypted_id = $request->subject;

            $main_page = 'assignments_management';
            $currentPage = "manage_subjects";
            return view('admin.subject-ops', ["subject" => $subject, 'main_page' => $main_page, 'currentPage' => $currentPage]);
        }
    }
}
