<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

abstract class Controller
{
    public function removeImage($existed_file_path)
    {
        unlink($existed_file_path);
        return;
    }

    public function storeImage($file, $path, $existed_file = "")
    {
        if (!empty($existed_file) && file_exists(public_path($existed_file))) {
            $fullPath = public_path($existed_file);
            if (file_exists($fullPath)) {
                $this->removeImage($fullPath);
            }
        }

        $fileName = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        $filePath = $path . $fileName;
        $fullFilePath = public_path($path);
        $file->move($fullFilePath, $fileName);
        return $filePath;
    }
}
