<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Admin\Pricing;
use App\Models\Customers;
use App\Models\CustomersPlans;
use App\Models\CustomersPlansTransactions;
use App\Models\Modules;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class CustomersController extends Controller
{
    public function getAllCustomers()
    {
        $customersData = Customers::select('id', 'first_name', 'last_name', 'email', 'password', 'terms', 'active_plan_id', 'status')->orderByDesc('position_order')->get();
        foreach ($customersData as $customer) {
            $customer->encrypted_id = Crypt::encrypt($customer->id);
            $customer->active_plan = ($customer->active_plan_id != 0) ? Pricing::where('id', $customer->active_plan_id)->value('plan_name') : 'Free';
        }
        $currentPage = "manage_customers";
        $model = Crypt::encrypt('Customers');
        return view('admin.manage_customers', compact('customersData', 'model', 'currentPage'));
    }

    public function viewCustomer(Request $request)
    {
        $customer_id = Crypt::decrypt($request->customer);
        $customer = Customers::find($customer_id);
        $customer_plan = null;
        $customer_transaction = null;
        if (isset($customer->active_plan_id) && $customer->active_plan_id != 0) {
            $customer_plan = CustomersPlans::with([
                'plan:id,plan_name,plan_price,plan_price_base,plan_storage_limit',
                'invoice:id,invoice_number,status'
            ])
                ->select('transaction_id', 'plan_status', 'start_date', 'expiry_date', 'plan_id', 'invoice_id')
                ->where([
                    'customer_id' => $customer_id,
                    'plan_id'     => $customer->active_plan_id,
                ])
                ->first();
            if (isset($customer_plan->transaction_id) && $customer_plan->transaction_id != 0) {
                $customer_transaction = CustomersPlansTransactions::select('payment_gateway', 'gateway_order_id', 'gateway_payment_id', 'amount', 'currency', 'transaction_status')
                    ->where('id', $customer_plan->transaction_id)
                    ->first();
            }
            if ($customer_plan->invoice) {
                $customer_plan->invoice->encrypted_id = Crypt::encrypt($customer_plan->invoice->id);
            }
        }

        $customer->encrypted_id = $request->customer;

        $currentPage = "manage_customers";
        return view('admin.customer-ops', compact('customer', 'customer_plan', 'customer_transaction', 'currentPage'));
    }

    public function viewCustomerData(Request $request)
    {
        $customer_id = Crypt::decrypt($request->customer);
        $customer = Customers::find($customer_id);
        $modulesData = Modules::select('id', 'email_to', 'your_email', 'message', 'total_clicks', 'validity', 'status')->where('customer_id', $customer_id)->orderByDesc('id')->get();
        foreach ($modulesData as $module) {
            $module->encrypted_id = Crypt::encrypt($module->id);
            $module->is_valid = $module->validity && Carbon::parse($module->validity, 'Asia/Kolkata')->isPast() ? 'Invalid' : 'Valid';
        }

        $customer->encrypted_id = $request->customer;

        $currentPage = "manage_customers";
        return view('admin.manage_users_data', compact('customer', 'modulesData', 'currentPage'));
    }

    public function viewCustomerAllPayments(Request $request)
    {
        $customer_id = Crypt::decrypt($request->customer);
        $customer = Customers::findOrFail($customer_id);

        $customer_plans = CustomersPlans::with([
            'plan:id,plan_name,plan_price,plan_price_base,plan_storage_limit',
            'invoice:id,invoice_number,status',
            'transaction:id,plan_id,payment_gateway,gateway_order_id,gateway_payment_id,amount,currency,transaction_status'
        ])
            ->where('customer_id', $customer_id)
            ->get();

        foreach ($customer_plans as $plan) {
            if ($plan->invoice) {
                $plan->invoice->encrypted_id = Crypt::encrypt($plan->invoice->id);
            }
        }

        $customer->encrypted_id = $request->customer;

        $currentPage = "manage_customers";

        return view('admin.customer-payments', compact('customer', 'customer_plans', 'currentPage'));
    }
}
