<?php

namespace App\Http\Controllers;

use App\Models\CustomersInvoices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;

class CustomersInvoicesController extends Controller
{
    public function index()
    {
        $invoices = CustomersInvoices::with(['customer', 'plan', 'transaction'])->latest()->paginate(10);
        return response()->json($invoices);
    }

    public function show($id)
    {
        $inv_id = Crypt::decrypt($id);
        $invoice = CustomersInvoices::findOrFail($inv_id);

        // Check if PDF exists
        if (!$invoice->pdf_path || !Storage::disk('public')->exists($invoice->pdf_path)) {
            return abort(404, 'Invoice PDF not found');
        }

        // Return PDF to display in browser
        return response()->file(storage_path("app/public/{$invoice->pdf_path}"), [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline; filename="' . basename($invoice->pdf_path) . '"'
        ]);
    }

    public function download($id)
    {
        $inv_id = Crypt::decrypt($id);
        $invoice = CustomersInvoices::findOrFail($inv_id);
        if (!$invoice->pdf_path || !Storage::disk('public')->exists($invoice->pdf_path)) {
            return response()->json(['status' => 'error', 'message' => 'Invoice PDF not found'], 404);
        }
        return response()->download(storage_path("app/public/{$invoice->pdf_path}"));
    }
}
