<?php

namespace App\Http\Controllers;

use App\Models\Admin\Assignments;
use App\Models\Admin\Banners;
use App\Models\Admin\Blogs;
use App\Models\Admin\Categories;
use App\Models\Admin\Company;
use App\Models\Admin\Courses;
use App\Models\Admin\EducationalSessions;
use App\Models\Admin\Faqs;
use App\Models\Admin\Features;
use App\Models\Admin\Pages;
use App\Models\Admin\PageSections;
use App\Models\Admin\Partners;
use App\Models\Admin\Pricing;
use App\Models\Admin\Testimonials;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class SitePagesController extends Controller
{
    public function getPage(Request $request)
    {
        $page_id = $request->page_id;
        $this_page = Pages::where(["id" => $page_id, "status" => 'active'])->first();
        $page = [
            'page_headline' => $this_page->page_headline,
            'breadcrumb_headline' => $this_page->breadcrumb_headline,
            'page_image' => asset($this_page->page_image),
            'page_description' => html_entity_decode(htmlspecialchars_decode($this_page->description)),
        ];
        return response()->json($page, 200);
    }

    // public function getPage()
    // {
    //     $get_page = Pages::select('id', 'page_name')
    //     ->where('page_id', $pageId)
    //     ->where('parent_id', 0)
    //     ->where('status', 'active')
    //     ->orderBy('sort_order', 'asc')
    //     ->get()
    //     ->map(function ($section) {
    //         return [
    //             'id' => Crypt::encryptString($section->id),
    //             'page_name' => $section->page_name
    //         ];
    //     });
    // }

    public function getPageSections(Request $request)
    {
        $page_id = $request->page_id;
        $get_sections = PageSections::select('id', 'default_section_name', 'section_headline', 'section_image', 'description')->where('page_id', $page_id)->whereNull('parent_id')->where('status', 'active')->orderBy('position_order', 'asc')->get();
        $data = $get_sections->map(function ($section) {
            return [
                'id' => Crypt::encryptString($section->id),
                'default_section_name' => $section->default_section_name,
                'section_headline' => $section->section_headline,
                'section_img' => asset($section->section_image),
                'section_desc' => html_entity_decode(htmlspecialchars_decode($section->description))
            ];
        });

        return response()->json($data, 200);
    }

    public function getPageSection(Request $request)
    {
        $section_id = $request->section_id;
        $this_section = PageSections::select('default_section_name', 'section_headline', 'section_title', 'description', 'section_image', 'button_name')->where(["id" => $section_id, "status" => 'active'])->first();
        if ($this_section) {
            $section = [
                'default_section_name'  => $this_section->default_section_name,
                'section_headline' => $this_section->section_headline,
                'section_title' => $this_section->section_title,
                'section_image' => asset($this_section->section_image),
                'description'  => html_entity_decode(htmlspecialchars_decode($this_section->description)),
                'button_name' => $this_section->button_name
            ];
        }

        return response()->json($section, 200);
    }

    public function getPageSubsections(Request $request)
    {
        $page_id = $request->page_id;
        $section_id = $request->section_id;
        $parent_section = PageSections::select('section_title', 'section_headline', 'description', 'section_image', 'section_video')->where(["id" => $section_id, "status" => 'active'])->first();

        $getSubsections = PageSections::select('section_icon', 'section_image', 'section_headline', 'description')->where(["page_id" => $page_id, "parent_id" => $section_id, "status" => 'active'])->get();
        // if ($section_id == 13) {
        //     $data = $getSubsections->map(function ($section, $index) {
        //         return [
        //             'delay' => 0.2 + ($index + 0.1),
        //             'title' => $section->section_headline,
        //             'desc' => strip_tags(htmlspecialchars_decode($section->description)),
        //         ];
        //     });
        // } else {
        $data = $getSubsections->map(function ($section, $index) {
            return [
                'number' => '0' . ($index + 1),
                'delay' => 0.2 + ($index + 0.1),
                'sec_icon' => $section->section_icon,
                'icon' => asset($section->section_image),
                'title' => $section->section_headline,
                'desc' => html_entity_decode(html_entity_decode($section->description)),
            ];
        });
        // }

        return response()->json([
            'parent_section_title' => $parent_section->section_title,
            'parent_section_headline' => $parent_section->section_headline,
            'parent_section_description' => html_entity_decode(htmlspecialchars_decode($parent_section->description)),
            'parent_section_image' => asset($parent_section->section_image),
            'parent_section_video' => asset($parent_section->section_video),
            'subsections' => $data
        ], 200);
    }

    public function getBanners()
    {
        $banners = Banners::select('banner_headline', 'banner_title', 'description', 'button_name', 'other_button_name', 'banner_image')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allBanners = $banners->map(function ($banner, $index) {
            return [
                'id' => 'slide-assignments-' . $index,
                'title' => $banner->banner_headline,
                'subtitle' => $banner->banner_title,
                'text' => htmlspecialchars_decode($banner->description),
                'images' => [
                    asset($banner->banner_image)
                ],
                'ctaPrimary' => [
                    'text' => $banner->button_name,
                    'href' => '#'
                ],
                'ctaSecondary' => [
                    'text' => $banner->other_button_name,
                    'href' => '#'
                ],
            ];
        });

        return response()->json($allBanners, 200);
    }

    public function getCompanyData()
    {
        $website = Company::select('email', 'phone', 'whatsapp_phone', 'alternate_phone', 'location', 'facebook_url', 'x_url', 'linkedin_url', 'youtube_url', 'instagram_url', 'telegram_url', 'whatsapp_url', 'availability')->first();

        return response()->json([
            "email" => $website->email,
            "phone" => $website->phone,
            "whatsapp_phone" => $website->whatsapp_phone,
            "alternate_phone" => $website->alternate_phone,
            "location" => html_entity_decode(htmlspecialchars_decode($website->location)),
            "facebook_url" => $website->facebook_url,
            "x_url" => $website->x_url,
            "linkedin_url" => $website->linkedin_url,
            "youtube_url" => $website->youtube_url,
            "instagram_url" => $website->instagram_url,
            "telegram_url" => $website->telegram_url,
            "whatsapp_url" => $website->whatsapp_url,
            "availability" => html_entity_decode(htmlspecialchars_decode($website->availability)),
        ], 200);
    }

    public function getLinks()
    {
        $website = Company::select('company_icon', 'company_logo', 'company_footer_logo', 'footer_content_visibility', 'footer_content', 'facebook_url', 'linkedin_url', 'instagram_url')->first();
        $links = Pages::select('header_footer_name', 'client_page_urls', 'visibility')->where(["status" => 'active'])->get();
        $linkBars = $links->map(function ($link) {
            return [
                'header_page_name' => $link->header_footer_name,
                'page_link' => $link->client_page_urls,
                'page_visibility' => $link->visibility
            ];
        });

        return response()->json([
            "company_icon" => assert($website->company_icon),
            "company_logo" => asset($website->company_logo),
            "company_footer_logo" => asset($website->company_footer_logo),
            "footer_content_visibility" => $website->footer_content_visibility,
            "footer_content" => html_entity_decode(htmlspecialchars_decode($website->footer_content)),
            "facebook_url" => $website->facebook_url,
            "linkedin_url" => $website->linkedin_url,
            "instagram_url" => $website->instagram_url,
            "linkBars" => $linkBars
        ], 200);
    }

    public function getPartners()
    {
        $partners = Partners::select('partner_name', 'partner_image')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allPartners = $partners->map(function ($partner) {
            return [
                'partner_name' => $partner->partner_name,
                'partner_image' => asset($partner->partner_image)
            ];
        });

        return response()->json($allPartners, 200);
    }

    public function getFeatures()
    {
        $features = Features::select('feature_headline', 'description', 'feature_image')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allFeatures = $features->map(function ($feature) {
            return [
                'title' => $feature->feature_headline,
                'desc' => html_entity_decode(htmlspecialchars_decode($feature->description)),
                'img' => asset($feature->feature_image)
            ];
        });

        return response()->json($allFeatures, 200);
    }

    public function getFaqs()
    {
        $faqs = Faqs::select('question', 'answer')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allFaqs = $faqs->map(function ($faq) {
            return [
                'question' => $faq->question,
                'answer' => html_entity_decode(htmlspecialchars_decode($faq->answer))
            ];
        });

        return response()->json($allFaqs, 200);
    }

    public function getTestimonials()
    {
        $testimonials = Testimonials::select('client_name', 'description', 'rating_quantity', 'client_designation', 'client_city', 'client_image')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allTestimonials = $testimonials->map(function ($testimonial) {
            $stars = '';
            for ($i = 1; $i <= $testimonial->rating_quantity; $i++) {
                $stars .= '★';
            }

            return [
                'name' => $testimonial->client_name,
                'rating' => $stars,
                'designation' => $testimonial->client_designation,
                'location' => $testimonial->client_city,
                'description' => html_entity_decode(htmlspecialchars_decode($testimonial->description)),
                'image' => asset($testimonial->client_image)
            ];
        });

        return response()->json($allTestimonials, 200);
    }

    public function getPlans()
    {
        $plans = Pricing::select('id', 'plan_name', 'plan_category', 'plan_price', 'plan_price_base', 'short_description', 'description', 'plan_image')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allPlans = $plans->map(function ($plan) {
            return [
                'id' => Crypt::encrypt($plan->id),
                'org' => $plan->id,
                'title' => $plan->plan_name,
                'price' => $plan->plan_price,
                'price_per_base' => "₹" . $plan->plan_price . "/" . ($plan->plan_price_base == 'month' ? 'Month' : 'Year'),
                'img' => asset($plan->plan_image),
                'popular' => ($plan->plan_category == 'popular' ? true : false),
                'description' => html_entity_decode(htmlspecialchars_decode($plan->short_description)),
                'features' => html_entity_decode(htmlspecialchars_decode($plan->description))
            ];
        });

        return response()->json($allPlans, 200);
    }

    public function getBlogs()
    {
        $blogs = Blogs::select('blog_headline', 'blog_url', 'blog_category', 'short_description', 'description', 'blog_image', 'post_date')->where(["status" => 'active'])->orderBy('position_order')->get();
        $allBlogs = $blogs->map(function ($blog, $index) {
            return [
                'id' => ($index + 1),
                'title' => $blog->blog_headline,
                'slug' => $blog->blog_url,
                'image' => asset($blog->blog_image),
                'category' => ucwords($blog->blog_category),
                'date' => date("F j, Y", strtotime($blog->post_date)),
                'short_description' => strip_tags(html_entity_decode(htmlspecialchars_decode($blog->short_description))),
                'content' => html_entity_decode(htmlspecialchars_decode($blog->description))
            ];
        });

        return response()->json($allBlogs, 200);
    }

    public function getBlog(Request $request)
    {
        $blog_url = $request->blog_url;
        $this_blog = Blogs::select('blog_headline', 'blog_url', 'blog_category', 'short_description', 'description', 'blog_image', 'post_date')->where(["blog_url" => $blog_url, "status" => 'active'])->orderBy('position_order')->first();
        $blog = [
            'title' => $this_blog->blog_headline,
            'slug' => $this_blog->blog_url,
            'image' => asset($this_blog->blog_image),
            'category' => ucwords($this_blog->blog_category),
            'date' => date("F j, Y", strtotime($this_blog->post_date)),
            'content' => html_entity_decode(htmlspecialchars_decode($this_blog->description))
        ];

        return response()->json($blog, 200);
    }

    public function getAssignmentCategoriesCourses()
    {
        $assignment_categories = Categories::select('id', 'category_generated_id', 'category_label', 'category_icon')->where(['parent_id' => null, 'reference_type' => 'assignment', 'status' => 'active'])->get();
        $result = [];
        foreach ($assignment_categories as $assignment_category) {
            $related_courses = Courses::select('course_name AS title', 'course_code AS code')->where(['category_id' => $assignment_category->id, 'status' => 'active'])->get();

            $result[] = [
                'id'    => $assignment_category->category_generated_id,
                'label' => $assignment_category->category_label,
                'icon'  => $assignment_category->category_icon,
                'items' => $related_courses,
            ];
        }

        return response()->json([
            'success' => true,
            'categories' => $result
        ], 200);
    }

    public function getCourseAssignments(Request $request)
    {
        $course_code = $request->code;
        $course = Courses::select('id', 'course_headline', 'description', 'breadcrumb_headline')->where(['course_code' => $course_code, 'status' => 'active'])->first();

        if (! $course) {
            return response()->json([
                'success' => false,
                'message' => 'Course not found'
            ], 404);
        }

        $related_assignments = Assignments::select('assignment_code', 'assignment_subject_name', 'maximum_retail_price', 'selling_price', 'assignment_image', 'type_ids', 'language_ids', 'session_ids', 'coupon_ids')
            ->where(['course_id' => $course->id])
            ->get()
            ->append(['types', 'languages', 'sessions', 'coupons']);

        $allRelatedAssignments = $related_assignments->map(function ($rel_assignment) {
            return [
                'code'      => $rel_assignment->assignment_code,
                'title'     => $rel_assignment->assignment_subject_name,

                'types'     => $rel_assignment->types->pluck('type_name')->toArray(),
                'languages' => $rel_assignment->languages->pluck('language_name')->toArray(),
                'sessions'  => $rel_assignment->sessions->pluck('session_name')->toArray(),

                'price'     => (float) $rel_assignment->maximum_retail_price,
                'sale'      => (float) $rel_assignment->selling_price,
                'img'       => asset($rel_assignment->assignment_image),
            ];
        });

        return response()->json([
            'success' => true,
            'course' => $course,
            'list' => $allRelatedAssignments
        ], 200);
    }

    public function getSingleCourseAssignment(Request $request)
    {
        $course_code = $request->course_code;

        $course = Courses::select('id')
            ->where([
                'course_code' => $course_code,
                'status' => 'active'
            ])
            ->first();

        if (! $course) {
            return response()->json([
                'success' => false,
                'message' => 'Course not found'
            ], 404);
        }

        $assignment_code = $request->assignment_code;

        $assignment = Assignments::select(
            'assignment_code',
            'assignment_title',
            'breadcrumb_headline',
            'maximum_retail_price',
            'selling_price',
            'discount',
            'additional_discount',
            'discount_offer_expiry',
            'assignment_expiry',
            'assignment_quantity',
            'assignment_image',
            'short_description',
            'download_info',
            'description',
            'question_paper_image',
            'why_choose_headline',
            'cover_page_info',
            'meta_title',
            'meta_keyword',
            'meta_description',
            'type_ids',
            'language_ids',
            'session_ids',
            'coupon_ids'
        )
            ->where([
                'course_id' => $course->id,
                'assignment_code' => $assignment_code
            ])
            ->first()
            ->append(['types', 'languages', 'sessions', 'coupons']);

        if (! $assignment) {
            return response()->json([
                'success' => false,
                'message' => 'Assignment not found'
            ], 404);
        }

        // calculate discount %
        $discount = $assignment->discount;
        $additionalDiscount = $assignment->additional_discount;
        // $discount = 0;
        // if ($assignment->maximum_retail_price > 0) {
        //     $discount = round(
        //         (($assignment->maximum_retail_price - $assignment->selling_price) / $assignment->maximum_retail_price) * 100
        //     );
        // }

        $offerEndsOn = $assignment->discount_offer_expiry;

        $productData = [
            "code"                  => $assignment->assignment_code,
            "title"                 => $assignment->assignment_title,
            "breadcrumbTitle"       => $assignment->breadcrumb_headline,
            "maxRetailPrice"        => (float) $assignment->maximum_retail_price,
            "salePrice"             => (float) $assignment->selling_price,
            "assignment_quantity"   => (int) $assignment->assignment_quantity,
            "discount"              => $discount,
            "extraDiscount"         => $additionalDiscount,
            "offerEndsOn"           => $offerEndsOn ? date('c', strtotime($offerEndsOn)) : null,
            "assignmentsValidity"   => date('d M Y', strtotime($assignment->assignment_expiry)),
            "image"                 => asset($assignment->assignment_image),

            "types"                 => $assignment->types->pluck('type_name')->toArray(),
            "medium"                => $assignment->languages->pluck('language_name')->toArray(),
            "sessions"              => $assignment->sessions->pluck('session_name')->toArray(),
            "coupons"               => $assignment->coupons->map(function ($coupon) {
                return [
                    "couponName"        => $coupon->coupon_name,
                    "couponCode"        => $coupon->coupon,
                    "couponText"        => $coupon->coupon_relevant_text,
                    "couponValidity"    => $coupon->coupon_validity,
                ];
            })->toArray(),

            // placeholders — you can later fill from DB
            "highlightHeadline"  => "Why Choose Our Solved Assignment?",
            "highlights"         => [
                "Easy to Understand & Exam Focused",
                "Perfect for Scoring High Marks",
                "100% Secure Payment & Instant Access After Payment",
                "Time-Saving and 100% Refund Solution"
            ],

            "short_description"  => html_entity_decode(htmlspecialchars_decode($assignment->short_description)),
            "downloadInfo"       => html_entity_decode(htmlspecialchars_decode($assignment->download_info)),
            "main_description"   => html_entity_decode(htmlspecialchars_decode($assignment->description)),
            "assignmentDetails"  => [
                [
                    "title" => "University",
                    "text"  => "IGNOU (Indira Gandhi National Open University)"
                ],
                [
                    "title" => "Code",
                    "text"  => $assignment->assignment_code
                ],
            ],

            "questionPaperImage" => asset($assignment->question_paper_image),
            "coverPageInfo"      => html_entity_decode(htmlspecialchars_decode($assignment->short_description)),
        ];

        return response()->json([
            "success" => true,
            "assignment" => $productData,
        ], 200);
    }

    public function getCsvData()
    {
        dd("Data is imported!");
        $path = public_path('data/ignou_assignment.csv');
        $subjectPath = public_path('data/ignou_subject.csv');

        if (! file_exists($path) || ! file_exists($subjectPath)) {
            return "CSV file(s) not found.";
        }

        $rows = [];
        $subjects = [];

        /*
        |--------------------------------------------------------------------------
        | 1️⃣ READ SUBJECT CSV (lookup: subject_id => subject_name)
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($subjectPath, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));
                $row = array_combine($headers, $row);

                $subjectId   = $row['id'] ?? null;
                $subjectName = $row['subject_name'] ?? null;

                if ($subjectId) {
                    $subjects[$subjectId] = $subjectName;
                }
            }

            fclose($handle);
        }

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENTS CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) continue;

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));
                $row = array_combine($headers, $row);

                // assignment_code from alt_tag
                $assignmentCode = null;

                if (! empty($row['alt_tag'])) {
                    $parts = explode(' - ', $row['alt_tag']);
                    $assignmentCode = trim($parts[0]);
                }

                $row['assignment_code'] = $assignmentCode;

                // attach subject_name
                $subjectId = $row['subject_id'] ?? null;

                $row['subject_name'] = $subjectId && isset($subjects[$subjectId])
                    ? $subjects[$subjectId]
                    : null;

                $rows[] = $row;
            }

            fclose($handle);
        }

        /*
        |--------------------------------------------------------------------------
        | 3️⃣ FILTER
        |--------------------------------------------------------------------------
        */

        $filtered = array_filter($rows, function ($row) {
            return ($row['assignment_type'] ?? null) == 'Solved_PDF' &&
                ($row['assignment_language'] ?? null) == 'English';
        });

        /*
        |--------------------------------------------------------------------------
        | 4️⃣ TRANSFORM BASIC FIELDS
        |--------------------------------------------------------------------------
        */

        $transformed = array_map(function ($row) {

            if (($row['assignment_type'] ?? null) == 'Solved_PDF') {
                $row['type'] = 'solved';
            }

            if (($row['assignment_language'] ?? null) == 'English') {
                $row['languages'] = [2];
            }

            $row['type_ids'] = [2];

            return $row;
        }, $filtered);

        /*
        |--------------------------------------------------------------------------
        | 5️⃣ SESSION NORMALIZER
        |--------------------------------------------------------------------------
        */

        $months = '(January|February|March|April|May|June|July|August|September|October|November|December|Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Sept|Oct|Nov|Dec)';

        $normalizeSession = function ($value) use ($months) {

            if (! $value) return null;

            $value = str_replace(['–', '—'], '-', $value);

            // capture ALL month-year occurrences
            if (preg_match_all("/$months\\s+\\d{2,4}/i", $value, $matches)) {

                $dates = $matches[0];

                if (count($dates) === 1) {
                    return $dates[0];
                }

                return $dates[0] . ' - ' . $dates[count($dates) - 1];
            }

            return trim($value);
        };

        /*
        |--------------------------------------------------------------------------
        | 6️⃣ LOAD DB SESSIONS (build lookup: session_name => id)
        |--------------------------------------------------------------------------
        */

        $all_dynamic_sessions = EducationalSessions::select('id', 'session_name')->get();

        $sessionMap = $all_dynamic_sessions
            ->pluck('id', 'session_name')
            ->toArray();

        /*
        |--------------------------------------------------------------------------
        | 7️⃣ BUILD FINAL ROWS (attach session_id)
        |--------------------------------------------------------------------------
        */

        $finalRows = [];

        $position_order = (Assignments::max('position_order') ?? 0);

        foreach ($transformed as $row) {

            $rawSession = $row['session'] ?? null;

            $cleanSession = $normalizeSession($rawSession);

            $sessionId = $sessionMap[$cleanSession] ?? null;

            $position_order++;

            $finalRows[] = [
                'course_id'                 => 1,
                'type_ids'                  => json_encode($row['type_ids']),
                'language_ids'              => json_encode($row['languages']),
                'session_ids'               => json_encode($sessionId ? [$sessionId] : []),
                'position_order'            => $position_order,
                'assignment_type'           => $row['type'] ?? null,
                'assignment_code'           => $row['assignment_code'] ?? null,
                'assignment_subject_name'   => $row['subject_name'] ?? null,
                'assignment_title'          => $row['page_title'],
                'maximum_retail_price'      => $row['mrp_price'] ?? null,
                'selling_price'             => $row['final_price'] ?? null,
                'assignment_quantity'       => 10,
                'discount'                  => 50,
                'additional_discount'       => 0,
                'assignment_image'          => 'images/assignments/' . $row['th_image'],
                'question_paper_image'      => 'images/assignments/question_paper_images/' . $row['snapshot'],
                'short_description'         => '&lt;p&gt;IGNOU students must submit the assignment timely as it impacts the final grades. Every academic session has specific deadlines and if you miss these set dates, you may face penalties from the university. Stay updated until the official IGNOU publications so that you know the last date for submission.&lt;/p&gt;',
                'download_info'             => '&lt;h5&gt;Download your IGNOU Solved assignment PDF Instantly &amp;mdash; No Waiting, No Hassle!&lt;/h5&gt;&lt;p&gt;The moment your payment is completed and successful, the BCHCT-135 solved assignment PDF will be available for immediate download. No waiting &amp;mdash; access your assignment using any device:&lt;/p&gt;&lt;p&gt;Download your assignment now and don&#039;t risk the stress of your last-minute panic!&lt;/p&gt;',
                'description'               => '&lt;p class=&quot;text-secondary mb-2&quot;&gt;Looking for a ready-to-use and marks-boosting solved assignment for &lt;strong&gt; BCHCT-135 Solutions, Phase Equilibrium, Conductance, Electrochemistry And Functional Group Organic Chemistry-II&lt;/strong&gt;? This assignment is prepared strictly as per the latest IGNOU guidelines for the January 2024, December 2024, January 2025 and December 2025 sessions (English Medium).&lt;/p&gt;&lt;p class=&quot;text-secondary mb-0&quot;&gt;It is ideal for B.Sc. students who want accuracy, clarity, and quick access. This high-quality solved assignment helps you score better with minimal effort.&lt;/p&gt;',
                'cover_page_info'           => '&lt;h5&gt;IGNOU Assignment Cover Page Format: A Complete Guide to Clear Your Confusion with Instant PDF Download&lt;/h5&gt;&lt;p&gt;Don&amp;rsquo;t risk rejection &amp;mdash; access our step-by-step IGNOU cover page guide with a ready-to-fill format, perfectly aligned with the latest university guidelines&lt;/p&gt;',
                'meta_title'                => $row['page_title'] ?? null,
                'meta_keyword'              => $row['meta_tags'] ?? null,
                'meta_description'          => $row['meta_description'] ?? null
            ];
        }

        /*
        |--------------------------------------------------------------------------
        | 8️⃣ SAVE TO DB (bulk insert)
        |--------------------------------------------------------------------------
        */

        // DB::table('assignments')->insert($finalRows);
        $chunks = array_chunk($finalRows, 300);   // try 200–500 per batch

        foreach ($chunks as $chunk) {
            DB::table('assignments')->insert($chunk);
        }

        return "Import completed: " . count($finalRows) . " records saved.";
    }
}
