<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Assignments extends Model
{
    use HasFactory;

    protected $table = 'assignments';

    protected $fillable = [
        'course_id',
        'type_ids',
        'language_ids',
        'session_ids',
        'coupon_ids',
        'position_order',
        'assignment_code',
        'assignment_subject_name',
        'assignment_title',
        'breadcrumb_headline',
        'maximum_retail_price',
        'selling_price',
        'discount',
        'additional_discount',
        'discount_offer_expiry',
        'assignment_expiry',
        'assignment_quantity',
        'assignment_image',
        'short_description',
        'download_info',
        'description',
        'question_paper_image',
        'why_choose_headline',
        'included_headline',
        'included_icons',
        'included_titles',
        'included_descriptions',
        'cover_page_info',
        'terms_conditions_text',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'course_id' => 'integer',
        'type_ids' => 'json',
        'language_ids' => 'json',
        'session_ids' => 'json',
        'coupon_ids' => 'json',
        'position_order' => 'integer',
        'assignment_code' => 'string',
        'assignment_subject_name' => 'string',
        'assignment_title' => 'string',
        'breadcrumb_headline' => 'string',
        'maximum_retail_price' => 'decimal:2',
        'selling_price' => 'decimal:2',
        'discount' => 'integer',
        'additional_discount' => 'integer',
        'discount_offer_expiry' => 'datetime',
        'assignment_expiry' => 'datetime',
        'assignment_quantity' => 'integer',
        'assignment_image' => 'string',
        'short_description' => 'string',
        'download_info' => 'string',
        'description' => 'string',
        'question_paper_image' => 'string',
        'why_choose_headline' => 'string',
        'included_headline' => 'string',
        'included_icons' => 'json',
        'included_titles' => 'json',
        'included_descriptions' => 'json',
        'cover_page_info' => 'string',
        'terms_conditions_text' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];

    public function course()
    {
        return $this->belongsTo(Courses::class, 'course_id', 'id');
    }

    public function getTypesAttribute()
    {
        return Types::whereIn('id', $this->type_ids ?? [])->get();
    }

    public function getLanguagesAttribute()
    {
        return Medium::whereIn('id', $this->language_ids ?? [])->get();
    }

    public function getSessionsAttribute()
    {
        return EducationalSessions::whereIn('id', $this->session_ids ?? [])->get();
    }

    public function getCouponsAttribute()
    {
        return Coupons::whereIn('id', $this->coupon_ids ?? [])->get();
    }
}
