<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Categories extends Model
{
    use HasFactory;

    protected $table = 'categories';

    protected $fillable = [
        'parent_id',
        'position_order',
        'reference_type',
        'category_generated_id',
        'category_label',
        'category_icon',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'parent_id' => 'integer',
        'position_order' => 'integer',
        'reference_type' => 'string',
        'category_generated_id' => 'string',
        'category_label' => 'string',
        'category_icon' => 'string',
        'status' => 'string',
    ];

    public function courses()
    {
        return $this->hasMany(Courses::class, 'category_id', 'id');
    }
}
