<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $table = 'company';

    protected $fillable = [
        'company_icon',
        'company_logo',
        'company_footer_logo',
        'company_name',
        'socials_visibility',
        'facebook_url',
        'x_url',
        'linkedin_url',
        'youtube_url',
        'instagram_url',
        'telegram_url',
        'whatsapp_url',
        'footer_content_visibility',
        'footer_content',
        'phone',
        'whatsapp_phone',
        'alternate_phone',
        'email',
        'alternate_email',
        'footer_location',
        'availability',
        'location_visibility',
        'location',
        'alternate_location',
        'map_link_visibility',
        'map_link',
        'website_status'
    ];

    protected $casts = [
        'company_icon' => 'string',
        'company_logo' => 'string',
        'company_footer_logo' => 'string',
        'company_name' => 'string',
        'socials_visibility' => 'string',
        'facebook_url' => 'string',
        'x_url' => 'string',
        'linkedin_url' => 'string',
        'youtube_url' => 'string',
        'instagram_url' => 'string',
        'telegram_url' => 'string',
        'whatsapp_url' => 'string',
        'footer_content_visibility' => 'string',
        'footer_content' => 'string',
        'phone' => 'string',
        'whatsapp_phone' => 'string',
        'alternate_phone' => 'string',
        'email' => 'string',
        'alternate_email' => 'string',
        'footer_location' => 'string',
        'availability' => 'string',
        'location_visibility' => 'string',
        'location' => 'string',
        'alternate_location' => 'string',
        'map_link_visibility' => 'string',
        'map_link' => 'string',
        'website_status' => 'string'
    ];
}
