<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subjects extends Model
{
    use HasFactory;

    protected $table = 'subjects';

    protected $fillable = [
        'course_ids',
        'position_order',
        'subject_code',
        'subject_name',
        'subject_headline',
        'breadcrumb_headline',
        'subject_icon',
        'course_year',
        'course_semester',
        'short_description',
        'description',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'course_ids' => 'json',
        'position_order' => 'integer',
        'subject_code' => 'string',
        'subject_name' => 'string',
        'subject_headline' => 'string',
        'breadcrumb_headline' => 'string',
        'subject_icon' => 'string',
        'course_year' => 'string',
        'course_semester' => 'string',
        'short_description' => 'string',
        'description' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];

    public function getCoursesAttribute()
    {
        return Courses::whereIn('id', $this->course_ids ?? [])->get();
    }
}
