<?php

namespace App\Services;

use App\Mail\CustomerPlanInvoiceMail;
use App\Models\Admin\Pricing;
use App\Models\Customers;
use App\Models\CustomersInvoices;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

class InvoiceService
{
    public static function generateAndSend($transaction, $customerId, $planId)
    {
        $invoiceNumber = 'INV-' . strtoupper(uniqid());

        $invoice = CustomersInvoices::create([
            'transaction_id' => $transaction->id,
            'customer_id'    => $customerId,
            'plan_id'        => $planId,
            'invoice_number' => $invoiceNumber,
            'amount'         => $transaction->amount,
            'currency'       => $transaction->currency ?? 'INR',
            'status'         => $transaction->transaction_status,
        ]);

        $customer = Customers::find($customerId);
        $plan = Pricing::find($planId);

        // Generate PDF
        $pdf = Pdf::loadView('templates.invoices.invoice', [
            'invoice'     => $invoice,
            'transaction' => $transaction,
            'customer'    => $customer,
            'plan'        => $plan,
        ]);

        $pdfPath = 'invoices/' . date('y/m/d') . '/' . $invoiceNumber . '.pdf';
        Storage::disk('public')->put($pdfPath, $pdf->output());

        $invoice->update(['pdf_path' => $pdfPath]);
        $invoice->enc_id = Crypt::encrypt($invoice->id);

        // Send Email
        $customer = $transaction->customer;
        if ($customer && $customer->email) {
            // $downloadLink = url('/invoices/' . $invoice->enc_id . '/download');
            $downloadLink = route('invoice.download', $invoice->enc_id);
            Mail::to($customer->email)->send(new CustomerPlanInvoiceMail($invoice, $downloadLink));
        }

        return $invoice;
    }
}
