<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_sections', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('page_id');
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('position_order');
            $table->string('default_section_name', 255)->nullable();
            $table->string('section_title', 255)->nullable();
            $table->string('section_headline', 200)->nullable();
            $table->string('section_icon', 200)->nullable();
            $table->longText('description')->nullable();
            $table->string('button_name', 255)->nullable();
            $table->string('button_link', 200)->nullable();
            $table->string('section_image', 200)->nullable();
            $table->string('more_images', 255)->nullable();
            $table->string('section_video', 255)->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_sections');
    }
};
