@push('custom-js')
    <script>
        $(document).ready(function() {
            const partialDownloadedFilesChartWrapper = $('#partialDownloadedFilesChartWrapper');
            const partialDownloadedFilesChartEl = document.querySelector('#partialDownloadedFilesChart');

            if (!partialDownloadedFilesChartEl) return;

            $.ajax({
                url: "{{ route('partially.downloaded.chart.data') }}",
                method: "GET",
                dataType: "json",
                success: function(response) {
                    const {
                        months,
                        series,
                        total
                    } = response;
                    const currentYear = new Date().getFullYear();
                    partialDownloadedFilesChartEl.innerHTML = '';

                    $("#partialDownloadedFilesCount").text(total);

                    const partialDownloadedFilesChartConfig = {
                        series: [{
                            name: 'Partially Downloaded Files',
                            data: series
                        }],
                        chart: {
                            height: 215,
                            parentHeightOffset: 0,
                            parentWidthOffset: 0,
                            toolbar: {
                                show: false
                            },
                            type: 'area'
                        },
                        dataLabels: {
                            enabled: false
                        },
                        stroke: {
                            width: 2,
                            curve: 'smooth'
                        },
                        legend: {
                            show: false
                        },
                        markers: {
                            size: 6,
                            colors: 'transparent',
                            strokeColors: 'transparent',
                            strokeWidth: 4,
                            discrete: [{
                                fillColor: '#fff',
                                seriesIndex: 0,
                                dataPointIndex: series.length - 1,
                                strokeColor: '#ffab00',
                                strokeWidth: 2,
                                size: 6,
                                radius: 8
                            }],
                            hover: {
                                size: 7
                            }
                        },
                        colors: ['#ffab00'],
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 0.6,
                                opacityFrom: 0.5,
                                opacityTo: 0.25,
                                stops: [0, 95, 100]
                            }
                        },
                        grid: {
                            borderColor: '#e0e0e0',
                            strokeDashArray: 3,
                            padding: {
                                top: -20,
                                bottom: 10,
                                left: -10,
                                right: 8
                            }
                        },
                        xaxis: {
                            categories: months,
                            axisBorder: {
                                show: false
                            },
                            axisTicks: {
                                show: false
                            },
                            labels: {
                                show: true,
                                style: {
                                    fontSize: '13px',
                                    colors: '#6c757d'
                                }
                            }
                        },
                        yaxis: {
                            labels: {
                                show: false
                            },
                            min: 0
                        }
                    };

                    const partialDownloadedFilesChart = new ApexCharts(
                        partialDownloadedFilesChartEl,
                        partialDownloadedFilesChartConfig);

                    partialDownloadedFilesChart.render().then(() => {
                        // ✅ Append year label outside SVG area
                        const yearLabel = $('<div>', {
                            text: currentYear,
                            css: {
                                textAlign: 'center',
                                marginTop: '4px',
                                color: '#6c757d',
                                fontSize: '13px',
                                fontWeight: 500
                            }
                        });

                        // Place it after the chart container
                        $(partialDownloadedFilesChartEl).after(yearLabel);
                    });
                },
                error: function(xhr) {
                    console.error('Failed to load Downloaded Chart:', xhr);
                }
            });
        });
    </script>

    {{-- <script>
        $(document).ready(function() {
            const weeklyUploadedChartEl = $('#weeklyUploadedChart');
            const weeklyUploadedChangeText = $('#weeklyUploadedChangeText');

            if (weeklyUploadedChartEl.length) {
                $.ajax({
                    url: "{{ route('weekly.uploaded.data') }}",
                    method: "GET",
                    dataType: "json",
                    success: function(data) {
                        const {
                            this_week,
                            last_week,
                            difference,
                            percentage
                        } = data;

                        // Update info text dynamically
                        let diffText = '';
                        if (difference > 0) {
                            diffText = `${difference} more than last week (+${percentage}%)`;
                        } else if (difference < 0) {
                            // diffText = `${Math.abs(difference)} less than last week (${percentage}%)`;
                            diffText = `${Math.abs(difference)} less than last week`;
                        } else {
                            diffText = 'Same as last week';
                        }
                        weeklyUploadedChangeText.text(diffText);

                        // Create Apex radial chart
                        const weeklyUploadedConfig = {
                            series: [this_week],
                            chart: {
                                width: 100,
                                height: 100,
                                type: 'radialBar'
                            },
                            plotOptions: {
                                radialBar: {
                                    startAngle: 0,
                                    endAngle: 360,
                                    hollow: {
                                        size: '50%'
                                    },
                                    track: {
                                        background: '#e9ecef'
                                    },
                                    dataLabels: {
                                        show: true,
                                        value: {
                                            formatter: function(val) {
                                                return parseInt(val);
                                            },
                                            color: '#697a8d',
                                            fontSize: '14px',
                                            show: true
                                        },
                                        name: {
                                            show: false
                                        }
                                    }
                                }
                            },
                            fill: {
                                type: 'solid',
                                colors: ["#696cff"]
                            },
                            stroke: {
                                lineCap: 'round'
                            },
                            grid: {
                                padding: {
                                    top: -10,
                                    bottom: -15,
                                    left: -10,
                                    right: -10
                                }
                            }
                        };

                        const chart = new ApexCharts(weeklyUploadedChartEl[0], weeklyUploadedConfig);
                        chart.render();
                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching weekly uploaded data:", error);
                        weeklyUploadedChangeText.text("Failed to load data");
                    }
                });
            }
        });
    </script> --}}
@endpush
