@extends('admin.layouts.main-layout')
@php
    if (!empty($category->encrypted_id)) {
        $title = 'Edit Category';
    } else {
        $title = 'Add Category';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($category->encrypted_id) ? route('edit.category', ['type' => $type, 'category' => $category->encrypted_id]) : route('add.category', $type) }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.categories', $type) }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    {{-- 
                                    <div class="col-sm-6">
                                        <label for="reference_type" class="col-form-label">Reference Type</label>
                                        <select name="reference_type" id="reference_type" class="form-select">
                                            @if (!empty($category->encrypted_id))
                                            <option value="blog" {{ $category->reference_type == 'blog' ? 'selected' : '' }}>Blog</option>
                                            <option value="service" {{ $category->reference_type == 'service' ? 'selected' : '' }}>Service</option>
                                            @else
                                            <option value="blog">Blog</option>
                                            <option value="service">Service</option>
                                            @endif
                                        </select>
                                        @error('reference_type')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div> --}}
                                    <div class="col-sm-6">
                                        <label for="category_label" class="col-form-label">Category Label</label>
                                        <input type="text" class="form-control" id="category_label" name="category_label"
                                            value="{{ !empty($category->encrypted_id) ? $category->category_label : '' }}"
                                            placeholder="Enter Label" />
                                        @error('category_label')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="category_generated_id" class="col-form-label">Category Generated
                                            ID</label>
                                        {{-- <input type="text" class="form-control" id="category_generated_id"
                                            name="category_generated_id"
                                            value="{{ !empty($category->encrypted_id) ? $category->category_generated_id : '' }}"
                                            onblur="getUrl(this.id)" placeholder="Enter ID" /> --}}
                                        <input type="text" class="form-control" id="category_generated_id"
                                            name="category_generated_id"
                                            value="{{ !empty($category->encrypted_id) ? $category->category_generated_id : '' }}"
                                            placeholder="Enter ID" />
                                        @error('category_generated_id')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="category_icon" class="col-form-label">Category Icon (<i></i>
                                            Tag)</label>
                                        <input type="text" class="form-control" id="category_icon" name="category_icon"
                                            value="{{ !empty($category->encrypted_id) ? $category->category_icon : '' }}"
                                            placeholder="Enter <i></i> Tag Icon Class" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit"
                            value="{{ !empty($category->encrypted_id) ? 'Update Category' : 'Add Category' }}"
                            class="btn btn-primary" />
                        <a href="{{ route('manage.categories', $type) }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    {{--
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let category_name = $.trim($("#" + field_id).val());
            let id = "{{ !empty($category->encrypted_id) ? $category->encrypted_id : '' }}";
            // Replace '/' and spaces with '-'
            let category_url = category_name.replace(/[\/\s]+/g, '-').toLowerCase();
            if (category_name == "" || category_name == undefined || category_name == null) {
                errors += 1;
            }
            if (category_url == "" || category_url == undefined || category_url == null) {
                errors += 1;
            }
            if (errors > 0) {
                $("#category_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                category_url = category_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.category.link', ['category_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', category_url)
                    .replace('__ID__', id);
                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("category_url").value =
                        data; // Update input field with returned category_url
                        // $("#category_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>
    --}}
@endsection
