@extends('admin.layouts.main-layout')
@php
    if (!empty($coupon->encrypted_id)) {
        $title = 'Edit Coupon';
    } else {
        $title = 'Add Coupon';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($coupon->encrypted_id) ? route('edit.coupon', ['coupon' => $coupon->encrypted_id]) : route('add.coupon') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.coupons') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="reference_type" class="col-form-label">Reference Type</label>
                                        <select name="reference_type" id="reference_type" class="form-select">
                                            <option value="" disabled selected>-- Select Type --</option>
                                            @if (!empty($coupon->encrypted_id))
                                                <option value="assignment"
                                                    {{ $coupon->reference_type == 'assignment' ? 'selected' : '' }}>
                                                    Assignment</option>
                                                <option value="project"
                                                    {{ $coupon->reference_type == 'project' ? 'selected' : '' }}>Project
                                                </option>
                                            @else
                                                <option value="assignment">Assignment</option>
                                                <option value="project">Project</option>
                                            @endif
                                        </select>
                                        @error('reference_type')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="coupon_name" class="col-form-label">Coupon Name</label>
                                        <input type="text" class="form-control" id="coupon_name" name="coupon_name"
                                            value="{{ !empty($coupon->encrypted_id) ? $coupon->coupon_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('coupon_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="coupon_generated_id" class="col-form-label">Coupon Relevant Text</label>
                                        <input type="text" class="form-control" id="coupon_relevant_text"
                                            name="coupon_relevant_text"
                                            value="{{ !empty($coupon->encrypted_id) ? $coupon->coupon_relevant_text : '' }}"
                                            placeholder="Enter Text" />
                                        @error('coupon_relevant_text')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit" value="{{ !empty($coupon->encrypted_id) ? 'Update coupon' : 'Add coupon' }}"
                            class="btn btn-primary" />
                        <a href="{{ route('manage.coupons') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    {{--
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let coupon_name = $.trim($("#" + field_id).val());
            let id = "{{ !empty($coupon->encrypted_id) ? $coupon->encrypted_id : '' }}";
            // Replace '/' and spaces with '-'
            let coupon_url = coupon_name.replace(/[\/\s]+/g, '-').toLowerCase();
            if (coupon_name == "" || coupon_name == undefined || coupon_name == null) {
                errors += 1;
            }
            if (coupon_url == "" || coupon_url == undefined || coupon_url == null) {
                errors += 1;
            }
            if (errors > 0) {
                $("#coupon_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                coupon_url = coupon_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.coupon.link', ['coupon_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', coupon_url)
                    .replace('__ID__', id);
                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("coupon_url").value =
                        data; // Update input field with returned coupon_url
                        // $("#coupon_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>
    --}}
@endsection
