@extends('admin.layouts.main-layout')
<?php if (!empty($course->encrypted_id)) {
    $title = 'Edit Course';
} else {
    $title = 'Add Course';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($course->encrypted_id) ? route('edit.course', $course->encrypted_id) : route('add.course') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.courses') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="category_id" class="form-label">Category</label>
                                        <select name="category_id" id="category_id" class="form-select">
                                            <option value="">-- Select Category --</option>
                                            @foreach ($all_categories as $category)
                                                @if (!empty($course->encrypted_id))
                                                    <option value="{{ $category->encrypted_id }}"
                                                        {{ $course->category_id == $category->id ? 'selected' : '' }}>
                                                        {{ $category->category_label }}
                                                    </option>
                                                @else
                                                    <option value="{{ $category->encrypted_id }}">
                                                        {{ $category->category_label }}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_name" class="col-form-label">Course Name</label>
                                        <input type="text" class="form-control" id="course_name" name="course_name"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_name : old('course_name') }}"
                                            placeholder="Enter Name" />
                                        {{-- onblur="getUrl(this.id)" --}}
                                        @error('course_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_headline" class="col-form-label">Course Headline</label>
                                        <input type="text" class="form-control" id="course_headline"
                                            name="course_headline"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_headline : old('course_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('course_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_code" class="col-form-label">Course Code</label>
                                        <input type="text" class="form-control" id="course_code" name="course_code"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_code : old('course_code') }}"
                                            placeholder="Enter Code" />
                                        @error('course_code')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_icon" class="col-form-label">Course Icon</label>
                                        <input type="text" class="form-control" id="course_icon" name="course_icon"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_icon : old('course_icon') }}"
                                            placeholder="Enter <i></i> Tag" />
                                        @error('course_icon')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_duration" class="col-form-label">Course Duration (Years)</label>
                                        <input type="text" class="form-control" id="course_duration"
                                            name="course_duration"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_duration : old('course_duration') }}"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Duration In Years" />
                                        @error('course_duration')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    {{-- <div class="col-6">
                                        <label for="course_url" class="col-form-label">Course URL</label>
                                        <input type="text" class="form-control" id="course_url" name="course_url"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_url : old('course_url') }}"
                                            placeholder="Enter URL" />
                                        @error('course_url')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div> --}}
                                    {{-- <div class="col-6">
                                        <label for="course_category" class="col-form-label">Course Category</label>
                                        <input type="text" class="form-control" id="course_category" name="course_category"
                                            value="{{ !empty($course->encrypted_id) ? $course->course_category : old('course_category') }}"
                                            placeholder="Enter Category" />
                                        @error('course_category')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div> --}}
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description">{{ !empty($course->encrypted_id) ? htmlspecialchars_decode($course->short_description) : '' }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description">{{ !empty($course->encrypted_id) ? htmlspecialchars_decode($course->description) : '' }}</textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="{{ !empty($course->encrypted_id) ? $course->breadcrumb_headline : old('breadcrumb_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('breadcrumb_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    {{--
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_instagram" class="col-form-label">Writer Instagram URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_instagram" name="writer_instagram" value="{{ !empty($course->encrypted_id) ? $course->writer_instagram : '' }}" placeholder="Enter Instagram URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_linkedin" class="col-form-label">Writer LinkedIn URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_linkedin" name="writer_linkedin" value="{{ !empty($course->encrypted_id) ? $course->writer_linkedin : '' }}" placeholder="Enter LinkedIn URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_x" class="col-form-label">Writer X URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_x" name="writer_x" value="{{ !empty($course->encrypted_id) ? $course->writer_x : '' }}" placeholder="Enter X URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_facebook" class="col-form-label">Writer Facebook URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_facebook" name="writer_facebook" value="{{ !empty($course->encrypted_id) ? $course->writer_facebook : '' }}" placeholder="Enter Facebook URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_threads" class="col-form-label">Writer Instagram Threads URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_threads" name="writer_threads" value="{{ !empty($course->encrypted_id) ? $course->writer_threads : '' }}" placeholder="Enter Instagram Threads URL" />-->
                                <!--</div>-->
                                --}}
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="{{ !empty($course->encrypted_id) ? $course->meta_title : '' }}"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="{{ !empty($course->encrypted_id) ? $course->meta_keyword : '' }}"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description">{{ !empty($course->encrypted_id) ? htmlspecialchars_decode($course->meta_description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="row">
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="blog_image" class="col-form-label">Blog Image</label>
                                        @if (!empty($course->encrypted_id) && !empty($course->blog_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($course->blog_image) }}" alt="Blog_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="blog_image" name="blog_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="writer_image" class="col-form-label">Writer Image</label>
                                        @if (!empty($course->encrypted_id) && !empty($course->writer_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($course->writer_image) }}" alt="Writer_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="writer_image" name="writer_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                        </div> --}}
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="{{ !empty($course->encrypted_id) ? 'Update Course' : 'Add Course' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.courses') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
    {{-- <script>
        function getUrl(field_id) {
            let errors = 0;
            let blog_headline = $.trim($("#" + field_id).val());
            let id = "{{ !empty($course->encrypted_id) ? $course->encrypted_id : '' }}";

            // Replace '/' and spaces with '-'
            let blog_url = blog_headline.replace(/[\/\s]+/g, '-').toLowerCase();

            if (blog_headline == "" || blog_headline == undefined || blog_headline == null) {
                errors += 1;
            }
            if (blog_url == "" || blog_url == undefined || blog_url == null) {
                errors += 1;
            }

            if (errors > 0) {
                $("#blog_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                blog_url = blog_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.blog.link', ['blog_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', blog_url)
                    .replace('__ID__', id);

                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("blog_url").value = data; // Update input field with returned link
                        // $("#blog_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script> --}}

@endsection
