@extends('admin.layouts.main-layout')
@section('title', 'Dashboard')

@push('custom-css')
    <style>
        /* Base tab style */
        .nav-pills .nav-link {
            border-radius: 0.5rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        /* Uploaded tab active state */
        .nav-pills .uploaded-tab.active {
            background-color: #696cff !important;
            /* Bootstrap primary */
            color: #fff !important;
        }

        /* Downloaded tab active state */
        .nav-pills .downloaded-tab.active {
            background-color: #71dd37 !important;
            /* Bootstrap success */
            color: #fff !important;
        }

        /* Partial tab active state */
        .nav-pills .partial-tab.active {
            background-color: #ffab00 !important;
            /* Bootstrap warning */
            color: #000 !important;
        }

        /* Expired tab active state */
        .nav-pills .expired-tab.active {
            background-color: #ff4b2d !important;
            /* Bootstrap danger */
            color: #fff !important;
        }

        /* Inactive tab text color */
        .uploaded-tab {
            color: #696cff !important;
        }

        .downloaded-tab {
            color: #71dd37 !important;
        }

        .partial-tab {
            color: #ffab00 !important;
        }

        .expired-tab {
            color: #ff4b2d !important;
        }
    </style>
@endpush

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row">
                <div class="col-lg-12 mb-4 order-0">
                    <div class="card">
                        <div class="d-flex align-items-end row">
                            <div class="col-sm-7">
                                <div class="card-body">
                                    <h5 class="card-title text-primary">Welcome {{ Session::get('name') }}! 🎉</h5>
                                    <p class="mb-4">
                                        This is your <span class="fw-bold">Admin Panel</span> for
                                        <strong>"{{ Session::get('company_name') }}"</strong> website.
                                    </p>
                                    <a href="{{ route('edit.profile') }}" class="btn btn-sm btn-outline-primary">Go to
                                        Profile</a>
                                </div>
                            </div>
                            <div class="col-sm-5 text-center text-sm-left">
                                <div class="card-body pb-0 px-0 px-md-4">
                                    <img src="{{ asset('admin-assets/assets/img/illustrations/man-with-laptop-light.png') }}"
                                        height="140" alt="View Badge User"
                                        data-app-dark-img="{{ asset('admin-assets/assets/img/illustrations/man-with-laptop-dark.png') }}"
                                        data-app-light-img="{{ asset('admin-assets/assets/img/illustrations/man-with-laptop-light.png') }}" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- File Transfer Statistics -->
                @include('admin.components.file-transfer-stats')
                <!--/ File Transfer Statistics -->

                <!-- Expense Overview -->
                @include('admin.components.stats-charts')
                <!--/ Expense Overview -->

                <!-- Transactions -->
                @include('admin.components.plan-transactions')
                <!--/ Transactions -->
            </div>
        </div>
        <!-- / Content -->
        <!-- Footer -->
        <div class="content-backdrop fade"></div>
    </div>
    <!-- Content wrapper -->
@endsection
