@extends('admin.admin-layouts.main-layout')
<?php if(!empty($city)) {
    $title = "Edit City";
} else {
    $title = "Add City";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($city) ? route('edit.city', $city->encrypted_id) : route('add.city') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_cities') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">City Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($city) ? $city->position_order : '' }}" placeholder="Enter Position" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="city_name" class="col-sm-3 col-form-label">City Name</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="city_name" name="city_name" value="{{ !empty($city) ? $city->city_name : '' }}" placeholder="Enter Name" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($city) ? 'Update City' : 'Add City' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_cities') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

@endsection
