@extends('admin.admin-layouts.main-layout')

<?php if(!empty($subtreatment)) {

    $title = "Edit Sub-Treatment & Country-wise Costs Management";

} else {

    $title = "Add Sub-Treatment";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($subtreatment) ? route('edit.treatment.subtreatment', ["treatment" => $enc_treatment_id, "subtreatment" => $subtreatment->encrypted_id]) : route('add.treatment.subtreatment', $enc_treatment_id) }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('edit.cost.treatment', $enc_treatment_id) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @elseif (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Sub-Treatment Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($subtreatment) ? $subtreatment->position_order : '' }}" placeholder="Enter Position" />

                                    @error('position_order')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_title" class="col-sm-3 col-form-label">Sub-Treatment Title</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_title" name="treatment_title" value="{{ !empty($subtreatment) ? $subtreatment->treatment_title : '' }}" placeholder="Enter Title" onblur="getUrl(this.id)" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_link" class="col-sm-3 col-form-label">Sub-Treatment URL</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_link" name="treatment_link" value="{{ !empty($subtreatment) ? $subtreatment->treatment_link : '' }}" placeholder="Enter URL" />

                                    @error('treatment_link')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>
                            
                            <div class="row mb-3">

                                <label for="treatment_headline" class="col-sm-3 col-form-label">Sub-Treatment Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_headline" name="treatment_headline" value="{{ !empty($subtreatment) ? $subtreatment->treatment_headline : '' }}" placeholder="Enter Headline" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="average_cost" class="col-sm-3 col-form-label">Average Cost</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="average_cost" name="average_cost" value="{{ !empty($subtreatment) ? $subtreatment->average_cost : '' }}" placeholder="Enter Avg. Cost" />

                                    @error('average_cost')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="maximum_cost" class="col-sm-3 col-form-label">Maximum Cost</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="maximum_cost" name="maximum_cost" value="{{ !empty($subtreatment) ? $subtreatment->maximum_cost : '' }}" placeholder="Enter Max. Cost" />

                                    @error('maximum_cost')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="nature" class="col-sm-3 col-form-label">Nature of Treatment</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="nature" name="nature" value="{{ !empty($subtreatment) ? $subtreatment->nature : '' }}" placeholder="Enter Max. Cost" />

                                    @error('nature')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="duration" class="col-sm-3 col-form-label">Hospitalization Duration <small>(Approx)</small></label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="duration" name="duration" value="{{ !empty($subtreatment) ? $subtreatment->duration : '' }}" placeholder="Enter Max. Cost" />

                                    @error('duration')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>
                            
                            <div class="row mb-3">

                                <label for="description" class="col-sm-3 col-form-label">Description</label>

                                <div class="col-sm-9">

                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($subtreatment) ? htmlspecialchars_decode($subtreatment->description) : '' }}</textarea>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($subtreatment) ? "Update Sub-Treatment" : "Add Sub-Treatment" }}" class="btn btn-primary" />

                        <a href="{{ route('edit.cost.treatment', $enc_treatment_id) }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

        @if(!empty($subtreatment))

        <hr>

        <!-- Hoverable Table rows -->

        <div class="card mt-4">

            <h5 class="card-header">Country-wise Costs Management

                <a href="{{ route('add.subtreatment.cost', ["treatment" => $enc_treatment_id, "subtreatment" => $subtreatment->encrypted_id]) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>

            </h5>

            <div class="table-responsive text-nowrap px-4 pb-4">

                <table id="table" class="table table-hover">

                    <thead>

                        <tr>

                            <th>S. No.</th>

                            <th>Country Name</th>

                            <th>Country Cost</th>

                            <th>Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody class="table-border-bottom-0">

                        <?php $sno = 1; ?>

                        @foreach($costsData as $costs)



                        <tr>

                            <td><?= $sno; ?></td>

                            <td>{{ $costs->country_name }}</td>

                            <td>{{ $costs->cost }}</td>

                            <td>

                                <div class="form-check form-switch mb-2">

                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $costs->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $costs->status == 'active' ? 'checked' : ''; ?> />

                                </div>

                            </td>

                            <td>

                                <div class="dropdown">

                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">

                                        <i class="bx bx-dots-vertical-rounded"></i>

                                    </button>

                                    <div class="dropdown-menu">

                                        <a class="dropdown-item" href="{{ route('edit.subtreatment.cost', ["treatment" => $enc_treatment_id, "subtreatment" => $enc_subtreatment_id, "cost" => $costs->encrypted_id]) }}" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $costs->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>

                                    </div>

                                </div>

                            </td>

                        </tr>

                        <?php $sno++; ?>

                        @endforeach

                    </tbody>

                </table>

            </div>

        </div>

        <!--/ Hoverable Table rows -->

        @endif

    </div>

</div>


<script>


    function getUrl(id) {

        let treatment_title = $.trim($("#"+id).val());

        let treatment_link = treatment_title.replace(/\s+/g, '-').toLowerCase();

        $("#treatment_link").val(treatment_link);

    }



</script>



@endsection

