@extends('admin.admin-layouts.main-layout')

<?php if(!empty($team)) {

    $title = "Edit Team";

} else {

    $title = "Add Team";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($team) ? route('edit.team', $team->encrypted_id) : route('add.team') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_team') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Emp. Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($team) ? $team->position_order : '' }}" placeholder="Enter Position" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="emp_name" class="col-sm-3 col-form-label">Emp. Name</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="emp_name" name="emp_name" value="{{ !empty($team) ? $team->employee_name : '' }}" placeholder="Enter Name" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="emp_designation" class="col-sm-3 col-form-label">Emp. Designation</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="emp_designation" name="emp_designation" value="{{ !empty($team) ? $team->employee_designation : '' }}" placeholder="Enter Designation" />

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="emp_image" class="col-sm-3 col-form-label">Emp. Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($team))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $team->employee_image) }}" alt="Emp_Image" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="emp_image" name="emp_image" accept=".jpg, .jpeg, .png, .webp" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($team) ? 'Update Team' : 'Add Team' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_team') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection

