@extends('admin.layouts.main-layout')
@section('title', 'Manage Courses')

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @elseif (session('error'))
                <div class="alert alert-danger alert-dismissible" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Courses<a href="{{ route('add.course') }}"
                        class="btn rounded-pill btn-icon btn-outline-primary float-end"
                        style="font-size: 1.7em;">+</span></a></h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Manage Assignments</th>
                                <th>Course Code</th>
                                <th>Course Name</th>
                                <th>Course Headline</th>
                                <th>Course Position</th>
                                <th>Course Icon</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($coursesData as $course)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        <a class="btn btn-sm btn-primary"
                                            href="{{ route('manage.assignments', $course->encrypted_id) }}">
                                            <i class="bx bx-file me-1"></i> Assignments
                                        </a>
                                        {{-- <a class="btn btn-sm btn-primary"
                                            href="{{ route('manage.subjects', $course->encrypted_id) }}">
                                            <i class="bx bx-file me-1"></i> Subjects
                                        </a> --}}
                                    </td>
                                    <td><strong>{{ $course->course_code }}</strong></td>
                                    <td>{{ $course->course_name }}</td>
                                    <td>{{ $course->course_headline }}</td>
                                    <td>{{ $course->position_order }}</td>
                                    <td>
                                        @if (!empty($course->course_icon))
                                            <i class="fa-solid {{ $course->course_icon }}"></i>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $course->encrypted_id ?>');"
                                                type="checkbox" id="status<?= $sno ?>"
                                                <?= $course->status == 'active' ? 'checked' : '' ?> />
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="{{ route('edit.course', $course->encrypted_id) }}">
                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                </a>
                                                <button class="dropdown-item"
                                                    onclick="delete_item('<?= $model ?>', '<?= $course->encrypted_id ?>');">
                                                    <i class="bx bx-trash me-1"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();

        {{--
    // function getOnBanner(sno, encrypted_id) {
    //     let token = '{{ csrf_token() }}';
    //     $("#blog_on_banner" + sno).attr('disabled', true);
    //     $.ajax({
    //         url: "{{ route('blog.on.banner') }}",
    //         data: {'_token': token, 'encrypted_id': encrypted_id},
    //         type: "POST",
    //         dataType: 'json',
    //         success: function(result) {
    //             if(result.status == 'done') {
    //                 Swal.fire({
    //                     icon: "success",
    //                     title: result.message,
    //                     showConfirmButton: false,
    //                     timer: 1500
    //                 });
    //                 setTimeout(function() {
    //                     $("#blog_on_banner" + sno).attr('disabled', false);
    //                     location.reload();
    //                 }, 1500);
    //             }
    //             else {
    //                 Swal.fire({
    //                     icon: "error",
    //                     title: result.message,
    //                     showConfirmButton: false,
    //                     timer: 1500
    //                 });
    //             }
    //         }
    //     });
    // }
    --}}
    </script>
@endsection
