@extends('admin.layouts.main-layout')

@section('title', 'Manage Services')

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <!-- Hoverable Table rows -->
        <div class="card">
            <h5 class="card-header">Manage Services 
                <a href="{{ route('add.service') }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                <a href="{{ route('get.services.page') }}" class="btn btn-primary float-end me-2">Services Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Service Name & Sections</th>
                            <th>All Sub-Services</th>
                            <th>Service Position</th>
                            <th>Client Service URLs</th>
                            <th>Visibility</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        @foreach($servicesData as $services)
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                <a href="{{ route('get.service.sections', $services->encrypted_id) }}">
                                    <strong>{{ $services->service_name }}</strong>
                                </a>
                            </td>
                            <td>
                                <a href="{{ route('get.subservices', $services->encrypted_id) }}" class="btn btn-sm btn-info">
                                    <strong>{{ $services->service_name }}</strong>
                                </a>
                            </td>
                            <td>{{ $services->position_order }}</td>
                            <td>
                                <a href="{{ route('single.service', $services->service_url) }}">
                                    <small><strong>{{ $services->header_footer_name }}</strong></small>
                                </a>
                            </td>
                            <td>
                                <select onchange="change_visibility('<?= $model; ?>', <?= $sno; ?>, '<?= $services->encrypted_id; ?>');" id="visibility<?= $sno; ?>" class="form-select form-select-sm">
                                    <option value="none" <?= (($services->visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                    <option value="header" <?= (($services->visibility) == 'header' ? 'selected' : ''); ?>>HEADER</option>
                                    <option value="footer" <?= (($services->visibility) == 'footer' ? 'selected' : ''); ?>>FOOTER</option>
                                    <option value="both" <?= (($services->visibility) == 'both' ? 'selected' : ''); ?>>BOTH</option>
                                </select>
                                <div class="text-danger" id="visibility_error<?= $sno; ?>"></div>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $services->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $services->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('edit.service', $services->encrypted_id) }}" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $services->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>

@endsection

@section('admin-custom-js')
{{-- <script>
    $("#table").DataTable();
</script> --}}
@endsection