@extends('admin.layouts.main-layout')

@section('title', 'Manage Socials')



@section('content')

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Company Settings /</span> Socials Details</h4>

            <div class="row">
                <div class="col-md-12">
                    <form method="POST" enctype="multipart/form-data"
                        action="{{ route('edit.socials', $socials->encrypted_id) }}">
                        @csrf
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @elseif (session('success'))
                            <div class="alert alert-success alert-dismissible" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <!-- Account -->
                            <div class="card-body">
                                <div class="row">
                                    {{-- <div class="mb-3 col-md-6">
                                    <label for="socials_visibility" class="form-label">Socials Visibility</label>
                                    <select id="socials_visibility" name="socials_visibility" onchange="change_socials_visibility(this.value);" class="form-select">
                                        <option value="all" <? // = (($socials->socials_visibility) == 'all' ? 'selected' : ''); ?>>ALL</option>
                                        <option value="i_f" <? // = (($socials->socials_visibility) == 'i_f' ? 'selected' : ''); ?>>INSTAGRAM & FACEBOOK</option>
                                        <option value="i_x" <? // = (($socials->socials_visibility) == 'i_x' ? 'selected' : ''); ?>>INSTAGRAM & X</option>
                                        <option value="f_x" <? // = (($socials->socials_visibility) == 'f_x' ? 'selected' : ''); ?>>FACEBOOK & X</option>
                                        <option value="none" <? // = (($socials->socials_visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                    </select>
                                </div> --}}
                                    <div class="mb-3 col-md-6" id="fb_div">
                                        <label for="facebook_url" class="form-label">Facebook URL</label>
                                        <input type="text" class="form-control" id="facebook_url" name="facebook_url"
                                            value="{{ $socials->facebook_url }}" placeholder="Enter FB URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="x_div">
                                        <label for="x_url" class="form-label">X URL</label>
                                        <input type="text" class="form-control" id="x_url" name="x_url"
                                            value="{{ $socials->x_url }}" placeholder="Enter X URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="linkedin_div">
                                        <label for="linkedin_url" class="form-label">LinkedIn URL</label>
                                        <input type="text" class="form-control" id="linkedin_url" name="linkedin_url"
                                            value="{{ $socials->linkedin_url }}" placeholder="Enter LinkedIn URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="youtube_div">
                                        <label for="youtube_url" class="form-label">YouTube URL</label>
                                        <input type="text" class="form-control" id="youtube_url" name="youtube_url"
                                            value="{{ $socials->youtube_url }}" placeholder="Enter YouTube URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="insta_div">
                                        <label for="instagram_url" class="form-label">Instagram URL</label>
                                        <input type="text" class="form-control" id="instagram_url" name="instagram_url"
                                            value="{{ $socials->instagram_url }}" placeholder="Enter Instagram URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="telegram_div">
                                        <label for="telegram_url" class="form-label">Telegram URL</label>
                                        <input type="text" class="form-control" id="telegram_url" name="telegram_url"
                                            value="{{ $socials->telegram_url }}" placeholder="Enter Telegram URL" />
                                    </div>
                                    <div class="mb-3 col-md-6" id="insta_div">
                                        <label for="whatsapp_url" class="form-label">WhatsApp URL</label>
                                        <input type="text" class="form-control" id="whatsapp_url" name="whatsapp_url"
                                            value="{{ $socials->whatsapp_url }}" placeholder="Enter WhatsApp URL" />
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <input type="submit" value="Update Socials" class="btn btn-primary me-2" />
                                </div>

                            </div>
                            <!-- /Account -->
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // function change_socials_visibility(value) {
        //     if(value == "all") {
        //         $("#insta_div").show();
        //         $("#fb_div").show();
        //         $("#x_div").show();
        //     }
        //     else if(value == "i_f") {
        //         $("#insta_div").show();
        //         $("#fb_div").show();
        //         $("#x_div").hide();
        //     }
        //     else if(value == "i_x") {
        //         $("#insta_div").show();
        //         $("#fb_div").hide();
        //         $("#x_div").show();
        //     }
        //     else if(value == "f_x") {
        //         $("#insta_div").hide();
        //         $("#fb_div").show();
        //         $("#x_div").show();
        //     }
        //     else {
        //         $("#insta_div").hide();
        //         $("#fb_div").hide();
        //         $("#x_div").hide();
        //     }

        //     return false;
        // }

        // change_socials_visibility('{{ $socials->socials_visibility }}');
    </script>

@endsection
