@extends('admin.layouts.main-layout')
<?php if (!empty($page->encrypted_id)) {
    $title = 'Edit Page & Section Management';
} else {
    $title = 'Add Page';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="{{ !empty($page->encrypted_id) ? route('edit.page', $page->encrypted_id) : route('add.page') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header">{{ $title }}<span class="float-end"><a href="{{ route('manage.pages') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @elseif (session('success'))
                            <div class="alert alert-success alert-dismissible" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    @if (session()->get('role') == 'superadmin')
                                        <div class="col-6">
                                            <label for="client_page_link" class="col-form-label">Client Page Link</label>
                                            <input type="text" class="form-control" id="client_page_link"
                                                name="client_page_link"
                                                value="{{ !empty($page->encrypted_id) ? $page->client_page_urls : '' }}"
                                                placeholder="Enter URL" />
                                        </div>
                                    @endif
                                    <div class="col-6">
                                        <label for="page_name" class="col-form-label">Page Name</label>
                                        <input type="text" class="form-control" id="page_name" name="page_name"
                                            value="{{ !empty($page->encrypted_id) ? $page->page_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('page_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="header_footer_name" class="col-form-label">Name in Header &
                                            Footer</label>
                                        <input type="text" class="form-control" id="header_footer_name"
                                            name="header_footer_name"
                                            value="{{ !empty($page->encrypted_id) ? $page->header_footer_name : '' }}"
                                            placeholder="Enter Name for Header & Footer" />
                                        @error('header_footer_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="page_headline" class="col-form-label">Page Headline</label>
                                        <input type="text" class="form-control" id="page_headline" name="page_headline"
                                            value="{{ !empty($page->encrypted_id) ? $page->page_headline : '' }}"
                                            placeholder="Enter Headline" />
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="{{ !empty($page->encrypted_id) ? $page->breadcrumb_headline : '' }}"
                                            placeholder="Enter Headline" />
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea name="description" id="description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description">{{ !empty($page->encrypted_id) ? htmlspecialchars_decode($page->description) : '' }}</textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="{{ !empty($page->encrypted_id) ? $page->meta_title : '' }}"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="{{ !empty($page->encrypted_id) ? $page->meta_keyword : '' }}"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description">{{ !empty($page->encrypted_id) ? htmlspecialchars_decode($page->meta_description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body row">
                                <div class="col-12">
                                    <label for="page_image" class="col-form-label">Page Image</label>
                                    @if (!empty($page->encrypted_id) && !empty($page->page_image))
                                        <div class="my-3">
                                            <img src="{{ asset($page->page_image) }}" alt="Page_Image" class="rounded"
                                                height="50px" width="50px">
                                        </div>
                                    @endif
                                    <input class="form-control" type="file" id="page_image" name="page_image"
                                        accept="image/*" />
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="{{ !empty($page->encrypted_id) ? 'Update Page' : 'Add Page' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.pages') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
            @if (!empty($page->encrypted_id))
                <hr>
                <!-- Hoverable Table rows -->
                <div class="card mt-4">
                    <h5 class="card-header">Section Management
                        @if (session()->get('role') == 'superadmin')
                            <a href="{{ route('add.page.section', $page->encrypted_id) }}"
                                class="btn rounded-pill btn-icon btn-outline-primary float-end"
                                style="font-size: 1.7em;">+</span></a>
                        @endif
                        <a href="{{ route('get.sections.page', ['page' => $page->encrypted_id, 'section' => '0']) }}"
                            class="btn btn-primary float-end me-2">Sections Sequence</a>
                    </h5>
                    <div class="table-responsive text-nowrap px-4 pb-4">
                        <table id="section-table" class="table table-hover">
                            <thead>
                                <tr>
                                    <th>S. No.</th>
                                    <th>Section Title</th>
                                    <th>Section Headline</th>
                                    @if (session()->get('role') == 'superadmin')
                                        <th>Section Position</th>
                                    @endif
                                    <th>Section Image</th>
                                    <th>More Images</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                                <?php $sno = 1; ?>
                                @foreach ($sectionsData as $sections)
                                    <tr>
                                        <td><?= $sno ?></td>
                                        <td>{{ $sections->section_title }}</td>
                                        <td>{{ $sections->section_headline }}</td>
                                        @if (session()->get('role') == 'superadmin')
                                            <td>{{ $sections->position_order }}</td>
                                        @endif
                                        <td>
                                            <ul
                                                class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                                @if (!empty($sections->section_image))
                                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom"
                                                        data-bs-placement="top" class="avatar avatar-md pull-up"
                                                        title="{{ $sections->section_headline }}">
                                                        <img src="{{ asset($sections->section_image) }}"
                                                            alt="Section_Image" class="rounded-circle" />
                                                    </li>
                                                @endif
                                            </ul>
                                        </td>
                                        <td>
                                            <ul
                                                class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                                @php
                                                    $more_images = json_decode($sections->more_images);
                                                @endphp
                                                @if (!empty($more_images))
                                                    @foreach ($more_images as $image)
                                                        <li data-bs-toggle="tooltip" data-popup="tooltip-custom"
                                                            data-bs-placement="top" class="avatar avatar-md pull-up"
                                                            title="{{ $sections->section_headline }}">
                                                            <img src="{{ asset($image) }}" alt="More_Images"
                                                                class="rounded-circle" />
                                                        </li>
                                                    @endforeach
                                                @endif
                                            </ul>
                                        </td>
                                        <td>
                                            <div class="form-check form-switch mb-2">
                                                <input class="form-check-input status_button"
                                                    onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $sections->encrypted_id ?>');"
                                                    type="checkbox" id="status<?= $sno ?>"
                                                    <?= $sections->status == 'active' ? 'checked' : '' ?> />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                    data-bs-toggle="dropdown">
                                                    <i class="bx bx-dots-vertical-rounded"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item"
                                                        href="{{ route('edit.page.section', ['page' => $page->encrypted_id, 'section' => $sections->encrypted_id]) }}"><i
                                                            class="bx bx-edit-alt me-1"></i> Edit</a>
                                                    @if (session()->get('role') == 'superadmin')
                                                        <button class="dropdown-item"
                                                            onclick="delete_item('<?= $model ?>', '<?= $sections->encrypted_id ?>');">
                                                            <i class="bx bx-trash me-1"></i> Delete
                                                        </button>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php $sno++; ?>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            @endif
        </div>
    </div>
@endsection

@section('admin-custom-js')
    <script>
        $("#section-table").DataTable();
    </script>
@endsection
