<?php

use App\Http\Controllers\ActionsController;
use App\Http\Controllers\Admin\AssignmentsController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\BannersController;
use App\Http\Controllers\Admin\BlogsController;
use App\Http\Controllers\Admin\CategoriesController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\CouponsController;
use App\Http\Controllers\Admin\CoursesController;
use App\Http\Controllers\Admin\DataController;
use App\Http\Controllers\Admin\DataInfoController;
use App\Http\Controllers\Admin\FaqsController;
use App\Http\Controllers\Admin\FeaturesController;
use App\Http\Controllers\Admin\PagesController;
use App\Http\Controllers\Admin\PartnersController;
use App\Http\Controllers\Admin\PricingController;
use App\Http\Controllers\Admin\TestimonialsController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\CustomersController;
use App\Models\Admin\Company;
use Illuminate\Support\Facades\Route;

// use Illuminate\Support\Facades\Artisan;

// Route::get('/run-artisan', function () {
//     // Artisan::call('migrate:status');
//     // Artisan::call('make:mail NewEmployeeMailer');
//     // Artisan::call('make:controller Admin/BlogsController');
//     // Artisan::call('make:model Admin/Blogs');
//     // Artisan::call('make:migration create_blogs_table');
//     // Artisan::call('make:middleware AdminChangeTemplateMiddleware');
//     // Artisan::call('migrate:refresh --path=database/migrations/2025_08_26_071923_create_blogs_table.php');
//     return Artisan::output();
// });

Route::get('/get-course-data', [DataController::class, 'getCsvData']);

Route::middleware(['noadminauth'])->group(function () {
    Route::match(['get', 'post'], '/register', [AuthController::class, 'register'])->name('register');
    Route::match(['get', 'post'], '/', [AuthController::class, 'login'])->name('login');
    Route::match(['get', 'post'], '/verify-otp', [AuthController::class, 'verifyOtp'])->name('verify.otp');
    Route::post('/resend-otp', [AuthController::class, 'resendOtp'])->name('resend.otp');
});

Route::middleware(['adminauth'])->group(function () {
    Route::match(['get', 'post'], '/change-website-status', [CompanyController::class, 'changeWebsiteStatus'])->name('change.website.status');
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
    Route::match(['get', 'post'], '/edit-profile', [AuthController::class, 'editProfile'])->name('edit.profile');
    Route::match(['get', 'post'], '/change-password', [AuthController::class, 'changePassword'])->name('change.password');
    Route::match(['get', 'post'], '/verify-change-password-otp', [AuthController::class, 'changePasswordVerifyOtp'])->name('verify.change.password.otp');
    Route::post('/resend-change-password-otp', [AuthController::class, 'resendOtp'])->name('resend.change.password.otp');
    Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/file-transfer-data', [AuthController::class, 'fileTransferData'])->name('file.transfer.data');
    Route::get('/uploaded-chart-data', [AuthController::class, 'uploadedChartData'])->name('uploaded.chart.data');
    Route::get('/weekly-uploaded-data', [AuthController::class, 'weeklyUploadedData'])->name('weekly.uploaded.data');
    Route::get('/downloaded-chart-data', [AuthController::class, 'downloadedChartData'])->name('downloaded.chart.data');
    Route::get('/partially-downloaded-chart-data', [AuthController::class, 'partiallyDownloadedChartData'])->name('partially.downloaded.chart.data');
    Route::get('/expired-chart-data', [AuthController::class, 'expiredChartData'])->name('expired.chart.data');
    Route::get('/transactions-data', [AuthController::class, 'getTransactionsData'])->name('transactions.data');


    //     Route::post('/upload_images', [ImagesController::class, 'uploadImages'])->name('upload.images');

    Route::get('/get-pages-page', [PagesController::class, 'getPagesPage'])->name('get.pages.page');
    Route::post('/pages-sequence', [PagesController::class, 'savePagesSequence'])->name('save.pages.sequence');
    Route::get('/check-page-link/{link}/{id?}', [PagesController::class, 'checkPageLink'])->name('check.page.link');
    Route::get('/manage-pages', [PagesController::class, 'managePages'])->name('manage.pages');
    Route::match(['get', 'post'], '/add-page', [PagesController::class, 'addPage'])->name('add.page');
    Route::match(['get', 'post'], '/edit-page/{page}', [PagesController::class, 'editPage'])->name('edit.page');

    Route::get('/get-sections-page/{page}/{section}', [PagesController::class, 'getSectionsPage'])->name('get.sections.page');
    Route::post('/sections_sequence', [PagesController::class, 'saveSectionsSequence'])->name('save.sections.sequence');
    Route::match(['get', 'post'], '/add-page-section/{page}', [PagesController::class, 'addPageSection'])->name('add.page.section');
    Route::match(['get', 'post'], '/edit-page-section/{page}/{section}', [PagesController::class, 'editPageSection'])->name('edit.page.section');
    Route::match(['get', 'post'], '/add-page-subsection/{page}/{section}', [PagesController::class, 'addPageSubSection'])->name('add.page.subsection');
    Route::match(['get', 'post'], '/edit-page-subsection/{page}/{section}/{subsection}', [PagesController::class, 'editPageSubSection'])->name('edit.page.subsection');

    Route::get('/manage-banners', [BannersController::class, 'manageBanners'])->name('manage.banners');
    Route::match(['get', 'post'], '/add-banner', [BannersController::class, 'addBanner'])->name('add.banner');
    Route::match(['get', 'post'], '/edit-banner/{banner}', [BannersController::class, 'editBanner'])->name('edit.banner');

    Route::get('/all-customers', [CustomersController::class, 'getAllCustomers'])->name('get.all.customers');
    Route::get('/view-customer/{customer}', [CustomersController::class, 'viewCustomer'])->name('view.customer');
    Route::get('/view-customer-data/{customer}', [CustomersController::class, 'viewCustomerData'])->name('view.customer.data');
    Route::get('/view-customer-all-payments/{customer}', [CustomersController::class, 'viewCustomerAllPayments'])->name('view.customer.all.payments');

    Route::get('/manage-partners', [PartnersController::class, 'managePartners'])->name('manage.partners');
    Route::match(['get', 'post'], '/add-partner', [PartnersController::class, 'addPartner'])->name('add.partner');
    Route::match(['get', 'post'], '/edit-partner/{partner}', [PartnersController::class, 'editPartner'])->name('edit.partner');

    Route::get('/manage-features', [FeaturesController::class, 'manageFeatures'])->name('manage.features');
    Route::match(['get', 'post'], '/add-feature', [FeaturesController::class, 'addFeature'])->name('add.feature');
    Route::match(['get', 'post'], '/edit-feature/{feature}', [FeaturesController::class, 'editFeature'])->name('edit.feature');

    Route::get('/manage-categories/{type}', [CategoriesController::class, 'manageCategories'])->name('manage.categories');
    Route::match(['get', 'post'], '/add-category/{type}', [CategoriesController::class, 'addCategory'])->name('add.category');
    Route::match(['get', 'post'], '/edit-category/{category}/{type}', [CategoriesController::class, 'editCategory'])->name('edit.category');

    Route::get('/manage-coupons', [CouponsController::class, 'manageCoupons'])->name('manage.coupons');
    Route::match(['get', 'post'], '/add-coupon', [CouponsController::class, 'addCoupon'])->name('add.coupon');
    Route::match(['get', 'post'], '/edit-coupon/{coupon}', [CouponsController::class, 'editCoupon'])->name('edit.coupon');

    Route::get('/manage-types', [DataInfoController::class, 'manageTypes'])->name('manage.types');
    Route::match(['get', 'post'], '/add-type', [DataInfoController::class, 'addType'])->name('add.type');
    Route::match(['get', 'post'], '/edit-type/{type}', [DataInfoController::class, 'editType'])->name('edit.type');
    Route::get('/manage-medium', [DataInfoController::class, 'manageMedium'])->name('manage.medium');
    Route::match(['get', 'post'], '/add-language', [DataInfoController::class, 'addLanguage'])->name('add.language');
    Route::match(['get', 'post'], '/edit-language/{language}', [DataInfoController::class, 'editLanguage'])->name('edit.language');
    Route::get('/manage-sessions', [DataInfoController::class, 'manageSessions'])->name('manage.sessions');
    Route::match(['get', 'post'], '/add-session', [DataInfoController::class, 'addSession'])->name('add.session');
    Route::match(['get', 'post'], '/edit-session/{session}', [DataInfoController::class, 'editSession'])->name('edit.session');

    Route::get('/check-course-link/{course_url}/{id?}', [CoursesController::class, 'checkCourseLink'])->name('check.course.link');
    Route::get('/manage-courses', [CoursesController::class, 'manageCourses'])->name('manage.courses');
    Route::match(['get', 'post'], '/add-course', [CoursesController::class, 'addCourse'])->name('add.course');
    Route::match(['get', 'post'], '/edit-course/{course}', [CoursesController::class, 'editCourse'])->name('edit.course');

    // Route::get('/check-assignment-link/{assignment_url}/{id?}', [AssignmentsController::class, 'checkAssignmentLink'])->name('check.assignment.link');
    // Route::get('/manage-assignments/{course}', [AssignmentsController::class, 'manageAssignments'])->name('manage.assignments');
    // Route::get('/get-why-choose-content/{assignment}', [AssignmentsController::class, 'getAssignmentWhyChoose'])->name('get.why.choose.content');
    // Route::post('/delete-why-choose', [AssignmentsController::class, 'deleteWhyChoose'])->name('delete.why.choose');
    // Route::get('/get-assignment-details-contents/{assignment}', [AssignmentsController::class, 'getAssignmentDetails'])->name('get.assignment.details.contents');
    // Route::post('/delete-assignment-details', [AssignmentsController::class, 'deleteAssignmentDetails'])->name('delete.assignment.details');
    // Route::match(['get', 'post'], '/add-assignment/{course}', [AssignmentsController::class, 'addAssignment'])->name('add.assignment');
    // Route::match(['get', 'post'], '/edit-assignment/{course}/{assignment}', [AssignmentsController::class, 'editAssignment'])->name('edit.assignment');

    Route::get('/check-subject-link/{subject_url}/{id?}', [AssignmentsController::class, 'checkSubjectLink'])->name('check.subject.link');
    Route::get('/manage-subjects/{course}', [AssignmentsController::class, 'manageSubjects'])->name('manage.subjects');
    Route::match(['get', 'post'], '/add-subject/{course}', [AssignmentsController::class, 'addSubject'])->name('add.subject');
    Route::match(['get', 'post'], '/edit-subject/{course}/{subject}', [AssignmentsController::class, 'editSubject'])->name('edit.subject');

    Route::get('/check-assignment-link/{assignment_url}/{id?}', [AssignmentsController::class, 'checkAssignmentLink'])->name('check.assignment.link');
    Route::get('/manage-assignments/{course}/{subject?}', [AssignmentsController::class, 'manageAssignments'])->name('manage.assignments');
    Route::get('/get-why-choose-content/{assignment}', [AssignmentsController::class, 'getAssignmentWhyChoose'])->name('get.why.choose.content');
    Route::post('/delete-why-choose', [AssignmentsController::class, 'deleteWhyChoose'])->name('delete.why.choose');
    Route::get('/get-assignment-details-contents/{assignment}', [AssignmentsController::class, 'getAssignmentDetails'])->name('get.assignment.details.contents');
    Route::post('/delete-assignment-details', [AssignmentsController::class, 'deleteAssignmentDetails'])->name('delete.assignment.details');
    Route::match(['get', 'post'], '/add-assignment/{course}/{subject?}', [AssignmentsController::class, 'addAssignment'])->name('add.assignment');
    Route::match(['get', 'post'], '/edit-assignment/{course}/{subject?}/{assignment}', [AssignmentsController::class, 'editAssignment'])->name('edit.assignment');

    Route::get('/manage-faqs', [FaqsController::class, 'manageFaqs'])->name('manage.faqs');
    Route::match(['get', 'post'], '/add-faq', [FaqsController::class, 'addFaq'])->name('add.faq');
    Route::match(['get', 'post'], '/edit-faq/{faq}', [FaqsController::class, 'editFaq'])->name('edit.faq');

    Route::get('/manage-testimonials', [TestimonialsController::class, 'manageTestimonials'])->name('manage.testimonials');
    Route::match(['get', 'post'], '/add-testimonial', [TestimonialsController::class, 'addTestimonial'])->name('add.testimonial');
    Route::match(['get', 'post'], '/edit-testimonial/{testimonial}', [TestimonialsController::class, 'editTestimonial'])->name('edit.testimonial');

    Route::get('/manage-plans', [PricingController::class, 'managePlans'])->name('manage.plans');
    Route::match(['get', 'post'], '/add-plan', [PricingController::class, 'addPlan'])->name('add.plan');
    Route::match(['get', 'post'], '/edit-plan/{plan}', [PricingController::class, 'editPlan'])->name('edit.plan');

    Route::get('/check-blog-link/{blog_url}/{id?}', [BlogsController::class, 'checkBlogLink'])->name('check.blog.link');
    Route::get('/manage-blogs', [BlogsController::class, 'manageBlogs'])->name('manage.blogs');
    Route::match(['get', 'post'], '/add-blog', [BlogsController::class, 'addBlog'])->name('add.blog');
    Route::match(['get', 'post'], '/edit-blog/{blog}', [BlogsController::class, 'editBlog'])->name('edit.blog');

    Route::get('/manage-guest-data', [DataController::class, 'manageGuestData'])->name('manage.guest.users.data');
    Route::get('/view-files-data/{module_id}/{customer_enc?}', [DataController::class, 'viewFiles'])->name('view.files');

    Route::get('/manage-company', [CompanyController::class, 'manageCompany'])->name('manage.company');
    Route::post('/edit-company/{company}', [CompanyController::class, 'editCompany'])->name('edit.company');

    Route::get('/manage-contact', [CompanyController::class, 'manageContact'])->name('manage.contact');
    Route::post('/edit-contact/{contact}', [CompanyController::class, 'editContact'])->name('edit.contact');

    Route::get('/manage-socials', [CompanyController::class, 'manageSocials'])->name('manage.socials');
    Route::post('/edit-socials/{socials}', [CompanyController::class, 'editSocials'])->name('edit.socials');
    Route::match(['get', 'post'], '/change-visibility', [ActionsController::class, 'changeVisibility'])->name('change.visibility');
    Route::match(['get', 'post'], '/change-status', [ActionsController::class, 'changeStatus'])->name('change.status');
    Route::match(['get', 'post'], '/delete-item', [ActionsController::class, 'deleteItem'])->name('delete.item');
});
