<?php if (!empty($course->encrypted_id)) {
    $title = 'Edit Course';
} else {
    $title = 'Add Course';
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e(!empty($course->encrypted_id) ? route('edit.course', $course->encrypted_id) : route('add.course')); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="<?php echo e(route('manage.courses')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="category_id" class="form-label">Category</label>
                                        <select name="category_id" id="category_id" class="form-select">
                                            <option value="">-- Select Category --</option>
                                            <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($course->encrypted_id)): ?>
                                                    <option value="<?php echo e($category->encrypted_id); ?>"
                                                        <?php echo e($course->category_id == $category->id ? 'selected' : ''); ?>>
                                                        <?php echo e($category->category_label); ?>

                                                    </option>
                                                <?php else: ?>
                                                    <option value="<?php echo e($category->encrypted_id); ?>">
                                                        <?php echo e($category->category_label); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_name" class="col-form-label">Course Name</label>
                                        <input type="text" class="form-control" id="course_name" name="course_name"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->course_name : old('course_name')); ?>"
                                            placeholder="Enter Name" />
                                        
                                        <?php $__errorArgs = ['course_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_headline" class="col-form-label">Course Headline</label>
                                        <input type="text" class="form-control" id="course_headline"
                                            name="course_headline"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->course_headline : old('course_headline')); ?>"
                                            placeholder="Enter Headline" />
                                        <?php $__errorArgs = ['course_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_code" class="col-form-label">Course Code</label>
                                        <input type="text" class="form-control" id="course_code" name="course_code"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->course_code : old('course_code')); ?>"
                                            placeholder="Enter Code" />
                                        <?php $__errorArgs = ['course_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_icon" class="col-form-label">Course Icon</label>
                                        <input type="text" class="form-control" id="course_icon" name="course_icon"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->course_icon : old('course_icon')); ?>"
                                            placeholder="Enter <i></i> Tag" />
                                        <?php $__errorArgs = ['course_icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="course_duration" class="col-form-label">Course Duration (Years)</label>
                                        <input type="text" class="form-control" id="course_duration"
                                            name="course_duration"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->course_duration : old('course_duration')); ?>"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Duration In Years" />
                                        <?php $__errorArgs = ['course_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description"><?php echo e(!empty($course->encrypted_id) ? htmlspecialchars_decode($course->short_description) : ''); ?></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description"><?php echo e(!empty($course->encrypted_id) ? htmlspecialchars_decode($course->description) : ''); ?></textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->breadcrumb_headline : old('breadcrumb_headline')); ?>"
                                            placeholder="Enter Headline" />
                                        <?php $__errorArgs = ['breadcrumb_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->meta_title : ''); ?>"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="<?php echo e(!empty($course->encrypted_id) ? $course->meta_keyword : ''); ?>"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description"><?php echo e(!empty($course->encrypted_id) ? htmlspecialchars_decode($course->meta_description) : ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="<?php echo e(!empty($course->encrypted_id) ? 'Update Course' : 'Add Course'); ?>"
                                class="btn btn-primary" />
                            <a href="<?php echo e(route('manage.courses')); ?>" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
    

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/course-ops.blade.php ENDPATH**/ ?>