<?php if (!empty($assignment->encrypted_id)) {
    $title = 'Edit Assignment';
} else {
    $title = 'Add Assignment';
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e(!empty($assignment->encrypted_id) ? route('edit.assignment', ['course' => $courseId, 'assignment' => $assignment->encrypted_id]) : route('add.assignment', $courseId)); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a
                            href="<?php echo e(route('manage.assignments', $courseId)); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="type_ids" class="form-label">Type(s)</label>
                                        <select name="type_ids[]" id="type_ids" class="form-select" multiple>
                                            <?php
                                                $selectedTypes = !empty($assignment->encrypted_id)
                                                    ? $assignment->types->pluck('id')->toArray()
                                                    : [];
                                            ?>
                                            <?php $__currentLoopData = $all_assignment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($assignment_type->encrypted_id); ?>"
                                                    <?php echo e(in_array($assignment_type->id, $selectedTypes) ? 'selected' : ''); ?>>
                                                    <?php echo e($assignment_type->type_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['type_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="language_ids" class="form-label">Medium</label>
                                        <?php
                                            $selectedLanguages = !empty($assignment->encrypted_id)
                                                ? $assignment->languages->pluck('id')->toArray()
                                                : [];
                                        ?>
                                        <select name="language_ids[]" id="language_ids" class="form-select" multiple>
                                            <?php $__currentLoopData = $all_assignment_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment_language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($assignment_language->encrypted_id); ?>"
                                                    <?php echo e(in_array($assignment_language->id, $selectedLanguages) ? 'selected' : ''); ?>>
                                                    <?php echo e($assignment_language->language_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['language_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="session_ids" class="form-label">Session(s)</label>
                                        <?php
                                            $selectedSessions = !empty($assignment->encrypted_id)
                                                ? $assignment->sessions->pluck('id')->toArray()
                                                : [];
                                        ?>
                                        <select name="session_ids[]" id="session_ids" class="form-select" multiple>
                                            <?php $__currentLoopData = $all_assignment_sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment_session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($assignment_session->encrypted_id); ?>"
                                                    <?php echo e(in_array($assignment_session->id, $selectedSessions) ? 'selected' : ''); ?>>
                                                    <?php echo e($assignment_session->session_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['session_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="coupon_ids" class="form-label">Coupon(s)</label>
                                        <?php
                                            $selectedCoupons = !empty($assignment->encrypted_id)
                                                ? $assignment->coupons->pluck('id')->toArray()
                                                : [];
                                        ?>
                                        <select name="coupon_ids[]" id="coupon_ids" class="form-select" multiple>
                                            <?php $__currentLoopData = $all_assignment_coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment_coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($assignment_coupon->encrypted_id); ?>"
                                                    <?php echo e(in_array($assignment_coupon->id, $selectedCoupons) ? 'selected' : ''); ?>>
                                                    <strong><?php echo e($assignment_coupon->coupon); ?>

                                                        <small><?php echo e($assignment_coupon->coupon_name); ?></small>
                                                    </strong>
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['coupon_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="assignment_code" class="col-form-label">Assignment Code</label>
                                        <input type="text" class="form-control" id="assignment_code"
                                            name="assignment_code"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->assignment_code : old('assignment_code')); ?>"
                                            oninput="this.value = this.value.replace(/[^A-Za-z0-9-]/g, '')"
                                            placeholder="Enter Code" />
                                        <?php $__errorArgs = ['assignment_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="assignment_subject_name" class="col-form-label">Assignment Subject
                                            Name</label>
                                        <input type="text" class="form-control" id="assignment_subject_name"
                                            name="assignment_subject_name"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->assignment_subject_name : old('assignment_subject_name')); ?>"
                                            placeholder="Enter Name" />
                                        <?php $__errorArgs = ['assignment_subject_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="assignment_title" class="col-form-label">Assignment Title</label>
                                        <input type="text" class="form-control" id="assignment_title"
                                            name="assignment_title"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->assignment_title : old('assignment_title')); ?>"
                                            placeholder="Enter Title" />
                                        
                                        <?php $__errorArgs = ['assignment_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb
                                            Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->breadcrumb_headline : old('breadcrumb_headline')); ?>"
                                            placeholder="Enter Headline" />
                                        <?php $__errorArgs = ['breadcrumb_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="assignment_quantity" class="col-form-label">Assignment Quantity</label>
                                        <input type="text" class="form-control" id="assignment_quantity"
                                            name="assignment_quantity"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->assignment_quantity : old('assignment_quantity')); ?>"
                                            placeholder="Enter Quantity"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');" />
                                        <?php $__errorArgs = ['assignment_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="maximum_retail_price" class="col-form-label">MRP</label>
                                        <input type="text" class="form-control" id="maximum_retail_price"
                                            name="maximum_retail_price"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->maximum_retail_price : old('maximum_retail_price')); ?>"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter MRP" />
                                        <?php $__errorArgs = ['maximum_retail_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="selling_price" class="col-form-label">Selling Price</label>
                                        <input type="text" class="form-control" id="selling_price"
                                            name="selling_price"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->selling_price : old('selling_price')); ?>"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Selling Price" />
                                        <?php $__errorArgs = ['selling_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="discount" class="col-form-label">Discount (In %)</label>
                                        <input type="text" class="form-control" id="discount" name="discount"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->discount : old('discount')); ?>"
                                            placeholder="Enter Discount"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');" />
                                        <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="additional_discount" class="col-form-label">Extra Discount (In
                                            %)</label>
                                        <input type="text" class="form-control" id="additional_discount"
                                            name="additional_discount"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->additional_discount : old('additional_discount')); ?>"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '');"
                                            placeholder="Enter Extra Discount" />
                                        <?php $__errorArgs = ['additional_discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="discount_offer_expiry" class="col-form-label">Discount Expiry</label>
                                        <input type="datetime-local" class="form-control" id="discount_offer_expiry"
                                            name="discount_offer_expiry"
                                            value="<?php echo e(!empty($assignment->encrypted_id) && $assignment->discount_offer_expiry ? \Carbon\Carbon::parse($assignment->discount_offer_expiry)->format('Y-m-d\TH:i') : old('discount_offer_expiry')); ?>"
                                            placeholder="Enter Discount Expiry" />
                                        <?php $__errorArgs = ['discount_offer_expiry'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-6">
                                        <label for="assignment_expiry" class="col-form-label">Assignment Expiry</label>
                                        <input type="datetime-local" class="form-control" id="assignment_expiry"
                                            name="assignment_expiry"
                                            value="<?php echo e(!empty($assignment->encrypted_id) && $assignment->assignment_expiry ? \Carbon\Carbon::parse($assignment->assignment_expiry)->format('Y-m-d\TH:i') : old('assignment_expiry')); ?>"
                                            placeholder="Enter Assignment Expiry" />
                                        <?php $__errorArgs = ['assignment_expiry'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control"
                                            placeholder="Enter Short Description"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->short_description) : ''); ?></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="download_info" class="col-form-label">Download Information</label>
                                        <textarea id="download_info" name="download_info" class="form-control" placeholder="Enter Download Information"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->download_info) : ''); ?></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->description) : ''); ?></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="cover_page_info" class="col-form-label">Cover Page Information</label>
                                        <textarea id="cover_page_info" name="cover_page_info" class="form-control" placeholder="Enter Cover Page Info"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->cover_page_info) : ''); ?></textarea>
                                    </div>
                                    
                                    <div class="col-12">
                                        <label for="terms_conditions_text" class="col-form-label">Terms &
                                            Conditions</label>
                                        <textarea id="terms_conditions_text" name="terms_conditions_text" class="form-control"
                                            placeholder="Enter Terms & Conditions"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->terms_conditions_text) : ''); ?></textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->meta_title : ''); ?>"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->meta_keyword : ''); ?>"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description"><?php echo e(!empty($assignment->encrypted_id) ? htmlspecialchars_decode($assignment->meta_description) : ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="assignment_image" class="col-form-label">Assignment Image</label>
                                        <?php if(!empty($assignment->encrypted_id) && !empty($assignment->assignment_image)): ?>
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="<?php echo e(asset($assignment->assignment_image)); ?>"
                                                    alt="assignment_image" class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        <?php endif; ?>
                                        <input class="form-control" type="file" id="assignment_image"
                                            name="assignment_image" accept="image/*" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="question_paper_image" class="col-form-label">Question Paper
                                            Image</label>
                                        <?php if(!empty($assignment->encrypted_id) && !empty($assignment->question_paper_image)): ?>
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="<?php echo e(asset($assignment->question_paper_image)); ?>"
                                                    alt="question_paper_image" class="rounded" height="60px"
                                                    width="60px" style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        <?php endif; ?>
                                        <input class="form-control" type="file" id="question_paper_image"
                                            name="question_paper_image" accept="image/*" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-3">
                                    <h5 class="card-header">Why Choose our Assignment Management</h5>
                                    <div class="card-body">
                                        <div class="col-12 mb-3">
                                            <label for="why_choose_headline" class="col-form-label">Why Choose
                                                Headline</label>
                                            <input type="text" class="form-control" id="why_choose_headline"
                                                name="why_choose_headline"
                                                value="<?php echo e(!empty($assignment->encrypted_id) ? $assignment->why_choose_headline : old('why_choose_headline')); ?>"
                                                placeholder="Enter Headline" />
                                            <?php $__errorArgs = ['why_choose_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div id="assignment-why-choose"></div>
                                        <span class="float-end"><button type="button" id="add-why-choose-row"
                                                class="btn rounded-pill btn-icon btn-primary float-end"
                                                style="font-size: 1.7em;">+</button></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-3">
                                    <h5 class="card-header">Assignment Details</h5>
                                    <div class="card-body">
                                        <div id="assignment-details"></div>
                                        <span class="float-end"><button type="button" id="add-detail-row"
                                                class="btn rounded-pill btn-icon btn-primary float-end"
                                                style="font-size: 1.7em;">+</button></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="<?php echo e(!empty($assignment->encrypted_id) ? 'Update Assignment' : 'Add Assignment'); ?>"
                                class="btn btn-primary" />
                            <a href="<?php echo e(route('manage.assignments', $courseId)); ?>"
                                class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    <script>
        new MultiSelectTag('type_ids');
        new MultiSelectTag('language_ids');
        new MultiSelectTag('session_ids');
        new MultiSelectTag('coupon_ids');
    </script>

    

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let whyChoose = 1;

            // Function to add a new row
            function addWhyChooseRow(item = {}) {

                // Create the first row (Section Headline)
                const row1 = document.createElement('div');
                row1.className = 'row mb-3';

                // Hidden input for ID
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'choose_ids[]';
                idInput.value = item.choose_id || '';
                row1.appendChild(idInput);

                // Input for Section Headline
                const col1 = document.createElement('div');
                col1.className = 'col-sm-11';

                const input1 = document.createElement('input');
                input1.type = 'text';
                input1.className = 'form-control';
                input1.id = `whyChooseContent-${whyChoose}`;
                input1.name = 'choose_contents[]';
                input1.placeholder = 'Enter Content';
                input1.value = item.choose_content || '';
                input1.required = true;

                // Prevent removal of the required attribute
                Object.defineProperty(input1, 'required', {
                    configurable: false,
                    writable: false,
                    value: true,
                });

                // Input for Section Headline
                const col2 = document.createElement('div');
                col2.className = 'col-sm-1';

                // Button div
                const buttonsDiv = document.createElement('div');
                buttonsDiv.classList.add('float-end');

                // Remove Button
                const removeButton = document.createElement('button');
                removeButton.type = 'button';
                removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
                removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
                removeButton.onclick = function() {
                    if (item && item.choose_id) {
                        $.ajax({
                            url: "<?php echo e(route('delete.why.choose')); ?>",
                            method: "POST",
                            data: {
                                'choose': item.choose_id,
                                '_token': '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(res) {
                                row1.remove();
                            }
                        });
                    } else {
                        row1.remove();
                    }
                };
                buttonsDiv.appendChild(removeButton);

                // Append input to column and label + column to row
                col1.appendChild(input1);
                col2.appendChild(buttonsDiv);
                row1.appendChild(col1);
                row1.appendChild(col2);

                // Append the new row to the form
                document.getElementById('assignment-why-choose').appendChild(row1);

                whyChoose++;
            }

            <?php if(!empty($assignment->encrypted_id)): ?>

                // Fetch data from the server (get_sub_section_data.php) and add rows
                fetch("<?php echo e(route('get.why.choose.content', $assignment->encrypted_id)); ?>")
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(item => {
                            addWhyChooseRow(item);
                        });
                    });
            <?php endif; ?>

            // Event listener to add a new blank row when "Add Row" button is clicked
            document.getElementById('add-why-choose-row').addEventListener('click', () => {
                addWhyChooseRow();
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let assignmentDetail = 1;

            // Function to add a new row
            function addAssignmentDetailRow(item = {}) {

                // Create the first row (Section Headline)
                const row1 = document.createElement('div');
                row1.className = 'row mb-3';

                // Hidden input for ID
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'detail_ids[]';
                idInput.value = item.detail_id || '';
                row1.appendChild(idInput);

                // Input for Section Headline
                const col1 = document.createElement('div');
                col1.className = 'col-sm-3';

                const input1 = document.createElement('input');
                input1.type = 'text';
                input1.className = 'form-control';
                input1.id = `assignmentDetail-${assignmentDetail}`;
                input1.name = 'detail_titles[]';
                input1.placeholder = 'Enter Title';
                input1.value = item.detail_title || '';
                input1.required = true;

                // Prevent removal of the required attribute
                Object.defineProperty(input1, 'required', {
                    configurable: false,
                    writable: false,
                    value: true,
                });

                const col2 = document.createElement('div');
                col2.className = 'col-sm-8';

                const input11 = document.createElement('input');
                input11.type = 'text';
                input11.className = 'form-control';
                input11.id = `assignmentDetail-${assignmentDetail}`;
                input11.name = 'detail_texts[]';
                input11.placeholder = 'Enter Text';
                input11.value = item.detail_text || '';
                input11.required = true;

                // Input for Section Headline
                const col3 = document.createElement('div');
                col3.className = 'col-sm-1';

                // Button div
                const buttonsDiv = document.createElement('div');
                buttonsDiv.classList.add('float-end');

                // Remove Button
                const removeButton = document.createElement('button');
                removeButton.type = 'button';
                removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
                removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
                removeButton.onclick = function() {
                    if (item && item.detail_id) {
                        $.ajax({
                            url: "<?php echo e(route('delete.assignment.details')); ?>",
                            method: "POST",
                            data: {
                                'detail': item.detail_id,
                                '_token': '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(res) {
                                row1.remove();
                            }
                        });
                    } else {
                        row1.remove();
                    }
                };
                buttonsDiv.appendChild(removeButton);

                // Append input to column and label + column to row
                col1.appendChild(input1);
                col2.appendChild(input11);
                col3.appendChild(buttonsDiv);
                row1.appendChild(col1);
                row1.appendChild(col2);
                row1.appendChild(col3);

                // Append the new row to the form
                document.getElementById('assignment-details').appendChild(row1);

                assignmentDetail++;
            }

            <?php if(!empty($assignment->encrypted_id)): ?>

                // Fetch data from the server (get_sub_section_data.php) and add rows
                fetch("<?php echo e(route('get.assignment.details.contents', $assignment->encrypted_id)); ?>")
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(item => {
                            addAssignmentDetailRow(item);
                        });
                    });
            <?php endif; ?>

            // Event listener to add a new blank row when "Add Row" button is clicked
            document.getElementById('add-detail-row').addEventListener('click', () => {
                addAssignmentDetailRow();
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/assignment-ops.blade.php ENDPATH**/ ?>