<?php
    if (isset($customer)) {
        $title = 'Manage Files Data regarding ' . $customer->first_name . ' ' . $customer->last_name;
    } else {
        $title = 'Manage Files Data';
    }
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header"><?php echo e($title); ?><span class="float-end">
                        <?php if($customer): ?>
                            <a href="<?php echo e(route('view.customer.data', $customer->encrypted_id)); ?>"
                                class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                    class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                    </span>
                <?php else: ?>
                    <a href="<?php echo e(route('manage.guest.users.data')); ?>"
                        class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                            style="font-size: 1.7rem;"></i></a></span>
                    <?php endif; ?>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>File Status</th>
                                <th>Total Downloads</th>
                                <th>File Name</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            <?php $__currentLoopData = $filesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $files): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        <?php if($files->file_status == 'removed'): ?>
                                            <strong class="text-danger">Removed</strong>
                                        <?php else: ?>
                                            <strong class="text-success">Valid</strong>
                                        <?php endif; ?>
                                    </td>
                                    <td><strong><?php echo e($files->total_downloads); ?></strong></td>
                                    <td><?php echo e($files->encrypted_name); ?></td>
                                </tr>
                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#table").DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/view_files_data.blade.php ENDPATH**/ ?>