<?php if(!empty($blog->encrypted_id)) {
    $title = "Edit Blog";
} else {
    $title = "Add Blog";
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($blog->encrypted_id) ? route('edit.blog', $blog->encrypted_id) : route('add.blog')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('manage.blogs')); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="blog_headline" class="col-form-label">Blog Headline</label>
                                    <input type="text" class="form-control" id="blog_headline" name="blog_headline" value="<?php echo e(!empty($blog->encrypted_id) ? $blog->blog_headline : ''); ?>" placeholder="Enter Headline" onblur="getUrl(this.id)" />
                                    <?php $__errorArgs = ['blog_headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="blog_url" class="col-form-label">Blog URL</label>
                                    <input type="text" class="form-control" id="blog_url" name="blog_url" value="<?php echo e(!empty($blog->encrypted_id) ? $blog->blog_url : ''); ?>" placeholder="Enter URL" />
                                    <?php $__errorArgs = ['blog_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="blog_category" class="form-label">Blog Category</label>
                                    <select name="blog_category" id="blog_category" class="form-select">
                                        <option value="">-- Select Category --</option>
                                        <?php if(!empty($blog->encrypted_id)): ?>
                                        <option value="growth" <?php echo e($blog->blog_category == 'growth' ? "selected" : ""); ?>>Growth</option>
                                        <?php else: ?>
                                        <option value="growth">Growth</option>
                                        <?php endif; ?>
                                    </select>
                                    <?php $__errorArgs = ['blog_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-12">
                                    <label for="short_description" class="col-form-label">Short Description</label>
                                    <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description"><?php echo e(!empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->short_description) : ''); ?></textarea>
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea id="description" name="description" class="form-control" placeholder="Enter Description"><?php echo e(!empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->description) : ''); ?></textarea>
                                </div>
                                <div class="col-6">
                                    <label for="written_by" class="col-form-label">Written By</label>
                                    <input type="text" class="form-control" id="written_by" name="written_by" value="<?php echo e(!empty($blog->encrypted_id) ? $blog->written_by : ''); ?>" placeholder="Enter Written By" />
                                    <?php $__errorArgs = ['written_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="col-6">
                                    <label for="meta_title" class="col-form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="<?php echo e(!empty($blog->encrypted_id) ? $blog->meta_title : ''); ?>" placeholder="Enter Meta Title" />
                                </div>
                                <div class="col-6">
                                    <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="<?php echo e(!empty($blog->encrypted_id) ? $blog->meta_keyword : ''); ?>" placeholder="Enter Meta Keyword" />
                                </div>
                                <div class="col-12">
                                    <label for="meta_description" class="col-form-label">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" ><?php echo e(!empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->meta_description) : ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <label for="blog_image" class="col-form-label">Blog Image</label>
                                    <?php if(!empty($blog->encrypted_id) && !empty($blog->blog_image)): ?>
                                    <div style="display: inline-block; position: relative; margin: 30px;" class="my-3">
                                        <img src="<?php echo e(asset($blog->blog_image)); ?>" alt="Blog_Image" class="rounded" height="60px" width="60px" style="object-fit: cover;">
                                        <button style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                    </div>
                                    <?php endif; ?>
                                    <input class="form-control" type="file" id="blog_image" name="blog_image" accept="image/*" />
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <label for="writer_image" class="col-form-label">Writer Image</label>
                                    <?php if(!empty($blog->encrypted_id) && !empty($blog->writer_image)): ?>
                                    <div style="display: inline-block; position: relative; margin: 30px;" class="my-3">
                                        <img src="<?php echo e(asset($blog->writer_image)); ?>" alt="Writer_Image" class="rounded" height="60px" width="60px" style="object-fit: cover;">
                                        <button style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                    </div>
                                    <?php endif; ?>
                                    <input class="form-control" type="file" id="writer_image" name="writer_image" accept="image/*" />
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($blog->encrypted_id) ? "Update Blog" : "Add Blog"); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.blogs')); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
<script>
    function getUrl(field_id) {
        let errors = 0;
        let blog_headline = $.trim($("#" + field_id).val());
        let id = "<?php echo e(!empty($blog->encrypted_id) ? $blog->encrypted_id : ''); ?>";

        // Replace '/' and spaces with '-'
        let blog_url = blog_headline.replace(/[\/\s]+/g, '-').toLowerCase();

        if(blog_headline == "" || blog_headline == undefined || blog_headline == null) {
            errors += 1;
        }
        if(blog_url == "" || blog_url == undefined || blog_url == null) {
            errors += 1;
        }

        if(errors > 0) {
            $("#blog_url").val("");
            return false;
        }
        else {
            // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
            blog_url = blog_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

            // Use Blade to generate the base route and append parameters dynamically
            let url = "<?php echo e(route('check.blog.link', ['blog_url' => '__LINK__', 'id' => '__ID__'])); ?>"
                .replace('__LINK__', blog_url)
                .replace('__ID__', id);

            // Send GET request with parameters in the URL
            fetch(url)
                .then(response => response.text()) // Expecting plain text response
                .then(data => {
                    document.getElementById("blog_url").value = data; // Update input field with returned link
                    // $("#blog_url").val(data);
                })
                .catch(error => console.error("Error:", error));
        }
    }
</script>



<?php echo $__env->yieldContent('editor'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.blog-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mateluas/wavedisk/wavedisk-api/laravel-api/resources/views/admin/blog-ops.blade.php ENDPATH**/ ?>