<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Content -->

    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <?php if($errors->has('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e($errors->first('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">
                                    <img src="<?php echo e(asset('images/company/1752844538_687a48fa6bbe3.png')); ?>" alt="Website_Logo"
                                        width="150px" height="90px">
                                </span>
                            </a>
                        </div>
                        <!-- /Logo -->
                        <h4 class="mb-2">Welcome to WaveDisk Admin Panel! 👋</h4>
                        <p class="mb-4">Please sign-in to your account.</p>

                        <form onsubmit="return checkInputs();" id="login_form" class="mb-3" action="<?php echo e(route('login')); ?>"
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="mail" class="form-label">E-Mail</label>
                                <input type="email" class="form-control" id="mail" name="mail"
                                    placeholder="Enter your E-Mail" autofocus />
                                <div id="mail_error" class="text-danger"></div>
                                <?php $__errorArgs = ['mail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3 form-password-toggle">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="pwd">Password</label>
                                    
                                </div>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="pwd" class="form-control" name="pwd"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password" />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                                <div id="pwd_error" class="text-danger"></div>
                                <?php $__errorArgs = ['pwd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="mb-3">
                                <button
                                    class="btn btn-primary d-grid w-100 d-flex justify-content-center align-items-center gap-2"
                                    id="loginBtn" type="submit">
                                    <span id="btnText">Sign-In</span>
                                    <span id="btnLoader" class="spinner-border spinner-border-sm d-none" role="status"
                                        aria-hidden="true"></span>
                                </button>

                            </div>
                        </form>

                        
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>

    <!-- / Content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <!-- Core JS -->
    <script>
        function checkInputs() {
            let errors = 0;
            const regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            let mail = $("#mail").val();
            let pwd = $("#pwd").val();

            if (mail == "" || mail == undefined || mail == null) {
                $("#mail_error").html("E-Mail is required!");
                errors += 1;
            } else {
                $("#mail_error").html("");
            }
            if (mail != "") {
                if (!regex.test(mail)) {
                    $("#mail_error").html("Invalid E-Mail");
                    errors += 1;
                } else {
                    $("#mail_error").html("");
                }
            }
            if (pwd == "" || pwd == undefined || pwd == null) {
                $("#pwd_error").html("Password is required!");
                errors += 1;
            } else {
                $("#pwd_error").html("");
            }

            if (errors > 0) {
                return false;
            } else {
                document.getElementById("btnText").textContent = "Please Wait...";
                document.getElementById("btnLoader").classList.remove("d-none");
                document.getElementById("loginBtn").disabled = true;
            }
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/login.blade.php ENDPATH**/ ?>