<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Your Secure Data Transfer is Ready ✅</title>
    <style>
        body {
            margin: 0;
            font-family: 'Inter', Arial, sans-serif;
            background-color: #f7f7f9;
            color: #333;
        }

        .container {
            max-width: 600px;
            background: #ffffff;
            margin: 40px auto;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        h2 {
            color: #4a148c;
            font-size: 22px;
            margin-bottom: 10px;
        }

        h3 {
            color: #333;
            margin-top: 25px;
        }

        p {
            line-height: 1.6;
            font-size: 15px;
            margin: 10px 0;
        }

        ul {
            margin: 10px 0 10px 20px;
            padding: 0;
        }

        li {
            font-size: 15px;
            line-height: 1.6;
        }

        .info-box {
            background: #f3e5f5;
            border-left: 5px solid #7b1fa2;
            padding: 15px;
            margin: 20px 0;
            border-radius: 6px;
        }

        .btn {
            display: inline-block;
            padding: 12px 25px;
            background: #7b1fa2;
            color: white !important;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 500;
            margin-top: 15px;
        }

        .qr-wrapper {
            text-align: center;
            margin: 25px 0;
        }

        .qr-wrapper img {
            width: 150px;
            height: 150px;
            border: 5px solid #eee;
            border-radius: 12px;
        }

        .footer {
            text-align: center;
            font-size: 13px;
            color: #777;
            margin-top: 30px;
        }

        @media (max-width: 600px) {
            .container {
                padding: 20px;
            }

            h2 {
                font-size: 20px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>✅ Your Secure Data Transfer is Ready</h2>

        <p>Dear User,</p>

        <p>
            Thank you for using <strong><?php echo e(env('APP_NAME_FOR_MAIL', 'Our Platform')); ?></strong> for your file transfer.
            Your data has been securely uploaded and is now ready for access.
            Please find your secure transfer details below:
        </p>

        <h3>🧭 How to Access Your Files</h3>
        <ul>
            <li>Click the transfer link or scan the QR code below.</li>
            <li>Enter the provided passcode when prompted.</li>
            <li>Download your files securely.</li>
        </ul>

        <p><strong>🔗 Share Link:</strong>
            <a href="<?php echo e($share_link); ?>" target="_blank"><?php echo e($share_link); ?></a>
        </p>

        <div class="info-box">
            <p><strong>🔐 Passcode:</strong> <?php echo e($passcode); ?></p>
        </div>

        <?php if(!empty($qr_cid)): ?>
            <div class="qr-wrapper">
                <p>📱 Or scan this QR code to open your files:</p>
                <img src="<?php echo e($message->embed(storage_path('app/temp/' . $qr_cid))); ?>" alt="QR Code" />
            </div>
        <?php endif; ?>

        <a href="<?php echo e($share_link); ?>" class="btn" target="_blank">Access Your Files</a>

        <p style="margin-top: 25px;">
            Please note: this transfer link will remain active until
            <strong><?php echo e($expiry_date ?? 'its expiration time'); ?></strong>, after which it will automatically expire
            for your data security.
        </p>

        <p>
            If you did not initiate or expect this transfer, please ignore this email
            or contact our support team immediately at
            <a
                href="mailto:<?php echo e(env('SUPPORT_EMAIL', 'support@example.com')); ?>"><?php echo e(env('SUPPORT_EMAIL', 'support@example.com')); ?></a>.
        </p>

        <p>
            Thank you for choosing <strong><?php echo e(env('APP_NAME_FOR_MAIL', 'Our Platform')); ?></strong> —
            your trusted platform for fast and secure data transfers.
        </p>

        <div class="footer">
            <p>© <?php echo e(date('Y')); ?> <?php echo e(env('APP_NAME_FOR_MAIL', 'Our Platform')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>

</html>
<?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/emails/share-file.blade.php ENDPATH**/ ?>