<?php
    if (!empty($category->encrypted_id)) {
        $title = 'Edit Category';
    } else {
        $title = 'Add Category';
    }
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e(!empty($category->encrypted_id) ? route('edit.category', ['type' => $type, 'category' => $category->encrypted_id]) : route('add.category', $type)); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="<?php echo e(route('manage.categories', $type)); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    
                                    <div class="col-sm-6">
                                        <label for="category_label" class="col-form-label">Category Label</label>
                                        <input type="text" class="form-control" id="category_label" name="category_label"
                                            value="<?php echo e(!empty($category->encrypted_id) ? $category->category_label : ''); ?>"
                                            placeholder="Enter Label" />
                                        <?php $__errorArgs = ['category_label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="category_generated_id" class="col-form-label">Category Generated
                                            ID</label>
                                        
                                        <input type="text" class="form-control" id="category_generated_id"
                                            name="category_generated_id"
                                            value="<?php echo e(!empty($category->encrypted_id) ? $category->category_generated_id : ''); ?>"
                                            placeholder="Enter ID" />
                                        <?php $__errorArgs = ['category_generated_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="category_icon" class="col-form-label">Category Icon (<i></i>
                                            Tag)</label>
                                        <input type="text" class="form-control" id="category_icon" name="category_icon"
                                            value="<?php echo e(!empty($category->encrypted_id) ? $category->category_icon : ''); ?>"
                                            placeholder="Enter <i></i> Tag Icon Class" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit"
                            value="<?php echo e(!empty($category->encrypted_id) ? 'Update Category' : 'Add Category'); ?>"
                            class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.categories', $type)); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/category-ops.blade.php ENDPATH**/ ?>