

<?php
    $title = 'View Payments regarding ' . $customer->first_name . ' ' . $customer->last_name;
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header"><?php echo e($title); ?><span class="float-end"><a href="<?php echo e(route('get.all.customers')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Plan</th>
                                <th>Plan Price <small>(In INR)</small></th>
                                <th>Expiration Date</th>
                                <th>Storage Limit <small>(In GBs)</small></th>
                                <th>Transaction Status</th>
                                <th>Payment Order ID</th>
                                <th>Payment ID</th>
                                <th>Invoice Number</th>
                                <th>Invoices</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            <?php $__currentLoopData = $customer_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td><?php echo e($customer_plan->plan->plan_name); ?></td>
                                    <td><?php echo e($customer_plan->plan->plan_price . '/' . ucwords($customer_plan->plan->plan_price_base)); ?>

                                    </td>
                                    <td><?php echo e(date('F d, Y', strtotime($customer_plan->expiry_date))); ?></td>
                                    <td><?php echo e($customer_plan->plan->plan_storage_limit); ?></td>
                                    <td><?php echo e($customer_plan->transaction->transaction_status == 'success' ? 'Successful' : 'Failed'); ?>

                                    </td>
                                    <td><?php echo e($customer_plan->transaction->gateway_order_id); ?></td>
                                    <td><?php echo e($customer_plan->transaction->gateway_payment_id); ?></td>
                                    <td><?php echo e($customer_plan->invoice->invoice_number); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('invoice.show', $customer_plan->invoice->encrypted_id)); ?>"
                                            target="_blank" class="btn btn-primary mt-2">
                                            View Invoice
                                        </a>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#table").DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/customer-payments.blade.php ENDPATH**/ ?>