<div class="col-md-6 col-lg-4 col-xl-4 order-0 mb-4">
    <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between pb-0">
            <div class="card-title mb-0">
                <h5 class="m-0 me-2">File Transfer Statistics</h5>
                <small class="text-muted">Overview of all file transfers</small>
            </div>
            
        </div>

        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex flex-column align-items-center gap-1">
                    <h2 class="mb-2"><?php echo e($data['files_count']); ?></h2>
                    <span>Total Transfers</span>
                </div>
                <div id="fileTransferChart"></div>
            </div>

            <ul class="p-0 m-0">
                <li class="d-flex mb-4 pb-1">
                    <div class="avatar flex-shrink-0 me-3">
                        <span class="avatar-initial rounded bg-label-primary"><i class="bx bx-upload"></i></span>
                    </div>
                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                        <div class="me-2">
                            <h6 class="mb-0">Uploaded</h6>
                            <small class="text-muted">Files sent or uploaded</small>
                        </div>
                        <div class="user-progress">
                            <small class="fw-semibold"><?php echo e($data['uploaded_count']); ?></small>
                        </div>
                    </div>
                </li>

                <li class="d-flex mb-4 pb-1">
                    <div class="avatar flex-shrink-0 me-3">
                        <span class="avatar-initial rounded bg-label-success"><i class="bx bx-download"></i></span>
                    </div>
                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                        <div class="me-2">
                            <h6 class="mb-0">Downloaded</h6>
                            <small class="text-muted">Completed file downloads</small>
                        </div>
                        <div class="user-progress">
                            <small class="fw-semibold"><?php echo e($data['downloaded_count']); ?></small>
                        </div>
                    </div>
                </li>

                <li class="d-flex mb-4 pb-1">
                    <div class="avatar flex-shrink-0 me-3">
                        <span class="avatar-initial rounded bg-label-warning"><i class="bx bx-transfer"></i></span>
                    </div>
                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                        <div class="me-2">
                            <h6 class="mb-0">Partially Downloaded</h6>
                            <small class="text-muted">Incomplete transfers</small>
                        </div>
                        <div class="user-progress">
                            <small class="fw-semibold"
                                id="partialCount"><?php echo e($data['partially_downloaded_count']); ?></small>
                        </div>
                    </div>
                </li>

                <li class="d-flex mb-4 pb-1">
                    <div class="avatar flex-shrink-0 me-3">
                        <span class="avatar-initial rounded bg-label-info"><i class="bx bx-time-five"></i></span>
                    </div>
                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                        <div class="me-2">
                            <h6 class="mb-0">Active Links</h6>
                            <small class="text-muted">Still valid for access</small>
                        </div>
                        <div class="user-progress">
                            <small class="fw-semibold"><?php echo e($data['activated_link_count']); ?></small>
                        </div>
                    </div>
                </li>

                <li class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                        <span class="avatar-initial rounded bg-label-danger"><i class="bx bx-block"></i></span>
                    </div>
                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                        <div class="me-2">
                            <h6 class="mb-0">Expired</h6>
                            <small class="text-muted">Links past validity</small>
                        </div>
                        <div class="user-progress">
                            <small class="fw-semibold"><?php echo e($data['expired_link_count']); ?></small>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>


<?php $__env->startPush('custom-js'); ?>
    <script>
        $(document).ready(function() {
            const fileTransferChartEl = document.querySelector('#fileTransferChart');

            if (!fileTransferChartEl) return;

            $.ajax({
                url: "<?php echo e(route('file.transfer.data')); ?>",
                method: "GET",
                dataType: "json",
                success: function(response) {
                    const {
                        labels,
                        series,
                        colors
                    } = response;

                    const chartOptions = {
                        chart: {
                            type: 'donut',
                            height: 165,
                            width: 130,
                        },
                        labels: labels,
                        series: series,
                        colors: colors,
                        stroke: {
                            width: 5,
                            colors: ['#fff']
                        },
                        dataLabels: {
                            enabled: false,
                            formatter: function(val) {
                                return parseInt(val);
                            }
                        },
                        legend: {
                            show: false,
                            position: 'bottom',
                            horizontalAlign: 'center',
                            labels: {
                                colors: '#666',
                                useSeriesColors: false
                            }
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    size: '75%',
                                    labels: {
                                        show: true,
                                        total: {
                                            show: true,
                                            label: 'Total',
                                            formatter: function(w) {
                                                return w.globals.seriesTotals.reduce((a, b) =>
                                                    a + b, 0);
                                            }
                                        },
                                        value: {
                                            fontSize: '1.2rem',
                                            color: '#000',
                                            offsetY: -10
                                        }
                                    }
                                }
                            }
                        },
                        grid: {
                            padding: {
                                top: 0,
                                bottom: 0
                            }
                        }
                    };

                    const donutChart = new ApexCharts(fileTransferChartEl, chartOptions);
                    donutChart.render();
                },
                error: function(xhr) {
                    console.error('Failed to load File Transfer chart data:', xhr);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/components/file-transfer-stats.blade.php ENDPATH**/ ?>