<?php if(!empty($page->encrypted_id)) {
    $title = "Edit Page & Section Management";
} else {
    $title = "Add Page";
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($page->encrypted_id) ? route('edit.page', $page->encrypted_id) : route('add.page')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?php echo e($title); ?><span class="float-end"><a href="<?php echo e(route('manage.pages')); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php elseif(session('success')): ?>
                    <div class="alert alert-success alert-dismissible" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <?php if(session()->get('role') == 'superadmin'): ?>
                                <div class="col-6">
                                    <label for="client_page_link" class="col-form-label">Client Page Link</label>
                                    <input type="text" class="form-control" id="client_page_link" name="client_page_link" value="<?php echo e(!empty($page->encrypted_id) ? $page->client_page_urls : ''); ?>" placeholder="Enter URL" />
                                </div>
                                <?php endif; ?>
                                <div class="col-6">
                                    <label for="page_name" class="col-form-label">Page Name</label>
                                    <input type="text" class="form-control" id="page_name" name="page_name" value="<?php echo e(!empty($page->encrypted_id) ? $page->page_name : ''); ?>" placeholder="Enter Name" />
                                    <?php $__errorArgs = ['page_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="header_footer_name" class="col-form-label">Name in Header & Footer</label>
                                    <input type="text" class="form-control" id="header_footer_name" name="header_footer_name" value="<?php echo e(!empty($page->encrypted_id) ? $page->header_footer_name : ''); ?>" placeholder="Enter Name for Header & Footer" />
                                    <?php $__errorArgs = ['header_footer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="page_headline" class="col-form-label">Page Headline</label>
                                    <input type="text" class="form-control" id="page_headline" name="page_headline" value="<?php echo e(!empty($page->encrypted_id) ? $page->page_headline : ''); ?>" placeholder="Enter Headline" />
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($page->encrypted_id) ? htmlspecialchars_decode($page->description) : ''); ?></textarea>
                                </div>
                                <div class="col-6">
                                    <label for="meta_title" class="col-form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="<?php echo e(!empty($page->encrypted_id) ? $page->meta_title : ''); ?>" placeholder="Enter Meta Title" />
                                </div>
                                <div class="col-6">
                                    <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="<?php echo e(!empty($page->encrypted_id) ? $page->meta_keyword : ''); ?>" placeholder="Enter Meta Keyword" />
                                </div>
                                <div class="col-12">
                                    <label for="meta_description" class="col-form-label">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" ><?php echo e(!empty($page->encrypted_id) ? htmlspecialchars_decode($page->meta_description) : ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="page_image" class="col-form-label">Page Image</label>
                                <?php if(!empty($page->encrypted_id) && !empty($page->page_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($page->page_image)); ?>" alt="Page_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="page_image" name="page_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($page->encrypted_id) ? 'Update Page' : 'Add Page'); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.pages')); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
        <?php if(!empty($page->encrypted_id)): ?>
        <hr>
        <!-- Hoverable Table rows -->
        <div class="card mt-4">
            <h5 class="card-header">Section Management
                <?php if(session()->get('role') == 'superadmin'): ?>
                <a href="<?php echo e(route('add.page.section', $page->encrypted_id)); ?>" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                <?php endif; ?>
                <a href="<?php echo e(route('get.sections.page', ["page" => $page->encrypted_id, "section" => '0'])); ?>" class="btn btn-primary float-end me-2">Sections Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="section-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Section Title</th>
                            <th>Section Headline</th>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <th>Section Position</th>
                            <?php endif; ?>
                            <th>Section Image</th>
                            <th>More Images</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        <?php $__currentLoopData = $sectionsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sections): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?= $sno; ?></td>
                            <td><?php echo e($sections->section_title); ?></td>
                            <td><?php echo e($sections->section_headline); ?></td>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <td><?php echo e($sections->position_order); ?></td>
                            <?php endif; ?>
                            <td>
                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                    <?php if(!empty($sections->section_image)): ?>
                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="<?php echo e($sections->section_headline); ?>" >
                                        <img src="<?php echo e(asset($sections->section_image)); ?>" alt="Section_Image" class="rounded-circle" />
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </td>
                            <td>
                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                    <?php
                                        $more_images = json_decode($sections->more_images);
                                    ?>
                                    <?php if(!empty($more_images)): ?>
                                        <?php $__currentLoopData = $more_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="<?php echo e($sections->section_headline); ?>" >
                                            <img src="<?php echo e(asset($image)); ?>" alt="More_Images" class="rounded-circle" />
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $sections->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $sections->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('edit.page.section', ["page" => $page->encrypted_id, "section" => $sections->encrypted_id])); ?>" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        <?php if(session()->get('role') == 'superadmin'): ?>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $sections->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
<script>
    $("#section-table").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravel_projects\wave-disk-api\resources\views/admin/page-ops.blade.php ENDPATH**/ ?>