<?php $__env->startSection('title', 'Manage Customers'); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <!-- Hoverable Table rows -->
        <div class="card">
            <h5 class="card-header">Manage Customers
                
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Customer Name</th>
                            <th>Customer E-Mail</th>
                            <th>Customer Position</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        <?php $__currentLoopData = $customersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                <strong><?php echo e($customers->first_name." ".$customers->last_name); ?></strong>
                            </td>
                            <td><?php echo e($customers->email); ?></td>
                            <td><?php echo e($customers->position_order); ?></td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $customers->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $customers->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('edit.customer', $customers->encrypted_id)); ?>" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $customers->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
<script>
    $("#table").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravel_projects\wave-disk-api\resources\views/admin/manage_customers.blade.php ENDPATH**/ ?>