<?php $__env->startSection('title', 'Manage Company'); ?>



<?php $__env->startSection('content'); ?>

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Company Settings /</span> Company Details</h4>

        <div class="row">
            <div class="col-md-12">
                <form method="POST" enctype="multipart/form-data" action="<?php echo e(route('edit.company', $company->encrypted_id)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php elseif(session('success')): ?>
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <!-- Account -->
                        <div class="row">
                            <div class="col-sm-4">
                                <h5 class="card-header">Company Icon</h5>
                                <div class="card-body">
                                    <div class="d-flex align-items-start align-items-sm-center gap-4">
                                        <img src="<?php echo e(asset($company->company_icon)); ?>" alt="Company-Icon" class="d-block rounded" height="100" width="100" id="uploadedIcon" title="Medotil Icon" />
                                        <div class="button-wrapper">
                                            <label for="uploadIcon" class="btn btn-primary me-2 mb-4" tabindex="0">
                                                <span class="d-none d-sm-block">Upload Icon</span>
                                                <i class="bx bx-upload d-block d-sm-none"></i>
                                                <input type="file" name="company_icon" id="uploadIcon" class="account-file-input" hidden accept="image/png, image/jpeg, image/jpg" />
                                            </label>
                                            <p class="text-muted mb-0">Allowed JPG, JPEG or PNG.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4" id="logo_div">
                                <h5 class="card-header">Company Logo</h5>
                                <div class="card-body">
                                    <div class="d-flex align-items-start align-items-sm-center gap-4">
                                        <img src="<?php echo e(asset($company->company_logo)); ?>" alt="Company-Logo" class="d-block rounded" height="100" width="100" id="uploadedImage" title="Medotil Logo" />
                                        <div class="button-wrapper">
                                            <label for="uploadImage" class="btn btn-primary me-2 mb-4" tabindex="0">
                                                <span class="d-none d-sm-block">Upload Logo</span>
                                                <i class="bx bx-upload d-block d-sm-none"></i>
                                                <input type="file" name="company_logo" id="uploadImage" class="account-file-input" hidden accept="image/png, image/jpeg, image/jpg" />
                                            </label>
                                            <p class="text-muted mb-0">Allowed JPG, JPEG or PNG.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <h5 class="card-header">Company Footer Logo</h5>
                                <div class="card-body">
                                    <div class="d-flex align-items-start align-items-sm-center gap-4">
                                        <img src="<?php echo e(asset($company->company_footer_logo)); ?>" alt="Company-Footer-Logo" class="d-block rounded" height="100" width="100" id="uploadedFooterImage" title="Medotil Footer Logo" />
                                        <div class="button-wrapper">
                                            <label for="uploadFooterImage" class="btn btn-primary me-2 mb-4" tabindex="0">
                                                <span class="d-none d-sm-block">Upload Footer Logo</span>
                                                <i class="bx bx-upload d-block d-sm-none"></i>
                                                <input type="file" name="company_footer_logo" id="uploadFooterImage" class="account-file-input" hidden accept="image/png, image/jpeg, image/jpg" />
                                            </label>
                                            <p class="text-muted mb-0">Allowed JPG, JPEG or PNG.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="my-0" />
                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6" id="company_website_div">
                                    <label for="company_name" class="form-label">Company Name</label>
                                    <input type="text" class="form-control" id="company_name" name="company_name" value="<?php echo e($company->company_name); ?>" placeholder="Enter Name" />
                                    <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mb-3 col-md-6" id="company_website_div">
                                    <label for="footer_content_visibility" class="form-label">Footer Content Visibility</label>
                                    <select name="footer_content_visibility" onchange="change_footer_content_visibility(this.value);" id="footer_content_visibility" class="form-select form-select">
                                        <option value="yes" <?php echo e(($company->footer_content_visibility == 'yes') ? 'selected' : ''); ?>>YES</option>
                                        <option value="no" <?php echo e(($company->footer_content_visibility == 'no') ? 'selected' : ''); ?>>NO</option>
                                    </select>
                                </div>
                                <div class="mb-3 col-md-6" id="footer_content_div">
                                    <label for="footer_content" class="form-label">Footer Content</label>
                                    <textarea name="footer_content" id="footer_content" cols="30" rows="5" class="form-control" placeholder="Enter Footer Content" ><?php echo e($company->footer_content); ?></textarea>
                                    <div id="footer_content_error" class="text-danger"></div>
                                </div>
                                
                            </div>
                            <div class="mt-2">
                                <input type="submit" value="Update" class="btn btn-primary me-2" />
                            </div>
                        </div>
                        <!-- /Account -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<script>

    // function change_newsletter_content_visibility(value) {
    //     if(value == "yes") {
    //         $("#newsletter_content_div").show();
    //     }
    //     else {
    //         $("#newsletter_content_div").hide();
    //     }
    //     return false;
    // }

    function change_footer_content_visibility(value) {
        if(value == "yes") {
            $("#footer_content_div").show();
        }
        else {
            $("#footer_content_div").hide();
        }
        return false;
    }

    // change_newsletter_content_visibility('<?php echo e($company->newsletter_content_visibility); ?>');
    change_footer_content_visibility('<?php echo e($company->footer_content_visibility); ?>');

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravel_projects\wave-disk-api\resources\views/admin/manage_company.blade.php ENDPATH**/ ?>