<?php
    $title = 'View Customer Details';
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <h5 class="card-header"><?php echo e($title); ?><span class="float-end"><a href="<?php echo e(route('get.all.customers')); ?>"
                        class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                            style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label class="form-label">Name</label>
                                    <p><?php echo e($customer->first_name . ' ' . $customer->last_name); ?></p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Mobile Number</label>
                                    <p><?php echo e($customer->mobile); ?></p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">E-Mail</label>
                                    <p><?php echo e($customer->email); ?></p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Status</label>
                                    <p><?php echo e($customer->status == 'active' ? 'Activated' : 'Blocked'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <h5 class="card-header">Active Plan Details</h5>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="plan_name" class="form-label">Plan</label>
                                    <?php if(isset($customer_plan->plan->plan_name) && !empty($customer_plan->plan->plan_name)): ?>
                                        <p><?php echo e($customer_plan->plan->plan_name); ?></p>
                                    <?php else: ?>
                                        <p>Free</p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Price</label>
                                    <?php if(isset($customer_plan->plan->plan_price) &&
                                            $customer_plan->plan->plan_price != 0 &&
                                            isset($customer_plan->plan->plan_price_base) &&
                                            $customer_plan->plan->plan_price_base != ''): ?>
                                        <p>
                                            <?php if($customer_transaction && $customer_transaction->currency): ?>
                                                <?php echo e($customer_transaction->currency); ?>

                                            <?php endif; ?>
                                            <?php echo e($customer_plan->plan->plan_price . '/' . ucwords($customer_plan->plan->plan_price_base)); ?>

                                        </p>
                                    <?php else: ?>
                                        <p>INR 0</p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Expirying On</label>
                                    <?php if(isset($customer_plan->expiry_date) && !empty($customer_plan->expiry_date)): ?>
                                        <p><?php echo e(date('F d, Y', strtotime($customer_plan->expiry_date))); ?></p>
                                    <?php else: ?>
                                        <p>Life-Time</p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Storage Limit</label>
                                    <?php if(isset($customer_plan->plan->plan_storage_limit) && $customer_plan->plan->plan_storage_limit != 0): ?>
                                        <p><?php echo e($customer_plan->plan->plan_storage_limit . ' GB'); ?></p>
                                    <?php else: ?>
                                        <p>1 GB</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($customer_transaction): ?>
                <h5 class="card-header">Payment Details</h5>
                <div class="row">
                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label">Transaction Status</label>
                                        <?php if(isset($customer_transaction->transaction_status) && !empty($customer_transaction->transaction_status)): ?>
                                            <p><?php echo e($customer_transaction->transaction_status == 'success' ? 'Successful' : 'Failed'); ?>

                                            </p>
                                        <?php else: ?>
                                            <p>Pending</p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(isset($customer_transaction->payment_gateway) && !empty($customer_transaction->payment_gateway)): ?>
                                        <div class="col-6">
                                            <label for="plan_name" class="form-label">Payment Gateway</label>
                                            <p><?php echo e($customer_transaction->payment_gateway); ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-6">
                                        <label class="form-label">Payment Order ID</label>
                                        <?php if(isset($customer_transaction->gateway_order_id) && !empty($customer_transaction->gateway_order_id)): ?>
                                            <p><?php echo e($customer_transaction->gateway_order_id); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label">Payment ID</label>
                                        <?php if(isset($customer_transaction->gateway_payment_id) && !empty($customer_transaction->gateway_payment_id)): ?>
                                            <p><?php echo e($customer_transaction->gateway_payment_id); ?>

                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($customer_plan && $customer_plan->invoice): ?>
                <h5 class="card-header">Payment Invoice Details</h5>
                <div class="row">
                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label">Invoice Status</label>
                                        <?php if(isset($customer_plan->invoice->status) && !empty($customer_plan->invoice->status)): ?>
                                            <p><?php echo e($customer_plan->invoice->status == 'success' ? 'Generated' : 'Failed'); ?>

                                            </p>
                                        <?php else: ?>
                                            <p>Pending</p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(isset($customer_plan->invoice->invoice_number) && !empty($customer_plan->invoice->invoice_number)): ?>
                                        <div class="col-6">
                                            <label for="plan_name" class="form-label">Invoice Number</label>
                                            <p><?php echo e($customer_plan->invoice->invoice_number); ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-6">
                                        <label class="form-label">Invoice</label>
                                        <?php if(isset($customer_plan->invoice->encrypted_id) && !empty($customer_plan->invoice->encrypted_id)): ?>
                                            <p>
                                                <a href="<?php echo e(route('invoice.show', $customer_plan->invoice->encrypted_id)); ?>"
                                                    target="_blank" class="btn btn-primary mt-2">
                                                    View Invoice
                                                </a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/customer-ops.blade.php ENDPATH**/ ?>